/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.tabular;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.EHTMLElement;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.AbstractHCElement;
import com.helger.html.hc.html.tabular.AbstractHCTablePart;
import com.helger.html.hc.html.tabular.HCColGroup;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTBody;
import com.helger.html.hc.html.tabular.HCTFoot;
import com.helger.html.hc.html.tabular.HCTHead;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractHCBaseTable<IMPLTYPE extends AbstractHCBaseTable<IMPLTYPE>>
extends AbstractHCElement<IMPLTYPE>
implements IHCTable<IMPLTYPE> {
    public static final ICSSClassProvider CSS_FORCE_COLSPAN = DefaultCSSClassProvider.create("force-colspan");
    private HCColGroup m_aColGroup;
    private int m_nCellSpacing = -1;
    private int m_nCellPadding = -1;
    private HCTHead m_aHead = new HCTHead();
    private HCTBody m_aBody = new HCTBody();
    private HCTFoot m_aFoot = new HCTFoot();

    protected AbstractHCBaseTable(@Nonnull @Nonempty EHTMLElement eHTMLElement) {
        super(eHTMLElement);
    }

    @Override
    @Nonnull
    public final HCTHead getHead() {
        return this.m_aHead;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHead(@Nonnull HCTHead hCTHead) {
        this.m_aHead = (HCTHead)ValueEnforcer.notNull((Object)hCTHead, (String)"Head");
        return (IMPLTYPE)((AbstractHCBaseTable)this.thisAsT());
    }

    @Override
    @Nonnull
    public final HCTBody getBody() {
        return this.m_aBody;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setBody(@Nonnull HCTBody hCTBody) {
        this.m_aBody = (HCTBody)ValueEnforcer.notNull((Object)hCTBody, (String)"Body");
        return (IMPLTYPE)((AbstractHCBaseTable)this.thisAsT());
    }

    @Override
    @Nonnull
    public final HCTFoot getFoot() {
        return this.m_aFoot;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFoot(@Nonnull HCTFoot hCTFoot) {
        this.m_aFoot = (HCTFoot)ValueEnforcer.notNull((Object)hCTFoot, (String)"Foot");
        return (IMPLTYPE)((AbstractHCBaseTable)this.thisAsT());
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    @Nonnegative
    public final int getChildCount() {
        return (this.m_aColGroup != null ? 1 : 0) + 3;
    }

    @Override
    @Nullable
    public final IHCNode getFirstChild() {
        return this.m_aColGroup != null ? this.m_aColGroup : this.m_aHead;
    }

    @Override
    @Nullable
    public final IHCNode getLastChild() {
        return this.getFoot();
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IHCNode> getAllChildren() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (this.m_aColGroup != null) {
            commonsArrayList.add((Object)this.m_aColGroup);
        }
        commonsArrayList.add((Object)this.m_aHead);
        commonsArrayList.add((Object)this.m_aBody);
        commonsArrayList.add((Object)this.m_aFoot);
        return commonsArrayList;
    }

    @Override
    @Nonnull
    public ICommonsIterable<? extends IHCNode> getChildren() {
        return this.getAllChildren();
    }

    @Override
    @Nullable
    public final IHCNode getChildAtIndex(@Nonnegative int n) {
        boolean bl;
        boolean bl2 = bl = this.m_aColGroup != null;
        if (n == 0) {
            return bl ? this.m_aColGroup : this.m_aHead;
        }
        if (n == 1) {
            return bl ? this.m_aHead : this.m_aBody;
        }
        if (n == 2) {
            return bl ? this.m_aBody : this.m_aFoot;
        }
        if (n == 3 && bl) {
            return this.m_aFoot;
        }
        return null;
    }

    @Override
    @CheckForSigned
    public final int getCellSpacing() {
        return this.m_nCellSpacing;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCellSpacing(int n) {
        this.m_nCellSpacing = n;
        return (IMPLTYPE)((AbstractHCBaseTable)this.thisAsT());
    }

    @Override
    @CheckForSigned
    public final int getCellPadding() {
        return this.m_nCellPadding;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setCellPadding(int n) {
        this.m_nCellPadding = n;
        return (IMPLTYPE)((AbstractHCBaseTable)this.thisAsT());
    }

    @Override
    @Nullable
    public final HCColGroup getColGroup() {
        return this.m_aColGroup;
    }

    @Override
    @Nonnull
    public final IMPLTYPE addColumn(@Nullable IHCCol<?> iHCCol) {
        if (iHCCol != null) {
            if (this.m_aColGroup == null) {
                this.m_aColGroup = new HCColGroup();
            }
            this.m_aColGroup.addColumn(iHCCol);
        }
        return (IMPLTYPE)((AbstractHCBaseTable)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE addColumnAt(@Nonnegative int n, @Nullable IHCCol<?> iHCCol) {
        if (iHCCol != null) {
            if (this.m_aColGroup == null) {
                this.m_aColGroup = new HCColGroup();
            }
            this.m_aColGroup.addColumnAt(n, iHCCol);
        }
        return (IMPLTYPE)((AbstractHCBaseTable)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeColumnAt(@Nonnegative int n) {
        if (this.m_aColGroup != null) {
            this.m_aColGroup.removeColumnAt(n);
        }
        return (IMPLTYPE)((AbstractHCBaseTable)this.thisAsT());
    }

    @Override
    @Nonnull
    public final IMPLTYPE removeAllColumns() {
        this.m_aColGroup = null;
        return (IMPLTYPE)((AbstractHCBaseTable)this.thisAsT());
    }

    @Override
    @Nonnegative
    public final int getColumnCount() {
        return this.m_aColGroup == null ? 0 : this.m_aColGroup.getColumnCount();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return this.m_aBody.canConvertToMicroNode(iHCConversionSettingsToNode) || this.m_aHead.canConvertToMicroNode(iHCConversionSettingsToNode) || this.m_aFoot.canConvertToMicroNode(iHCConversionSettingsToNode);
    }

    private static int _getApplicableRowspan(int n, @Nullable List<int[]> list) {
        int n2 = 0;
        if (list != null) {
            int n3 = 1;
            for (int[] nArray : list) {
                int n4;
                if (nArray != null && n < nArray.length && (n4 = nArray[n] - n3) > 0) {
                    ++n2;
                }
                ++n3;
            }
        }
        return n2;
    }

    @Nonnegative
    private static int _getEffectiveCellCount(@Nonnull HCRow hCRow, @Nullable List<int[]> list) {
        int n = 0;
        for (IHCCell iHCCell : hCRow.getAllChildren()) {
            n += AbstractHCBaseTable._getApplicableRowspan(n, list) + iHCCell.getColspan();
        }
        n += AbstractHCBaseTable._getApplicableRowspan(n, list);
        return n;
    }

    private static void _checkConsistency(@Nonnull String string, @Nonnull AbstractHCTablePart<?> abstractHCTablePart, @Nonnegative int n) {
        int n2 = 0;
        boolean bl = false;
        CommonsArrayList commonsArrayList = new CommonsArrayList(abstractHCTablePart.getChildCount());
        if (abstractHCTablePart.hasChildren()) {
            for (HCRow hCRow : abstractHCTablePart.getChildren()) {
                int n3 = AbstractHCBaseTable._getEffectiveCellCount(hCRow, (List<int[]>)(bl ? commonsArrayList : null));
                if (n3 != n) {
                    HCConsistencyChecker.consistencyError(string + " row #" + (n2 + 1) + " has " + n3 + " cells but was expecting " + n + " cells");
                }
                int[] nArray = new int[hCRow.getCellCount()];
                int n4 = 0;
                boolean bl2 = false;
                for (IHCCell iHCCell : hCRow.getAllChildren()) {
                    int n5 = iHCCell.getRowspan();
                    nArray[n4++] = n5;
                    if (n5 == 1) continue;
                    bl2 = true;
                }
                if (bl2) {
                    commonsArrayList.add(0, (Object)nArray);
                    bl = true;
                } else {
                    commonsArrayList.add(0, null);
                }
                ++n2;
            }
        }
    }

    @Override
    public void checkInternalConsistency() {
        int n = 0;
        if (this.m_aColGroup != null) {
            n = this.m_aColGroup.getColumnCount();
        }
        if (n == 0 && this.m_aHead.hasChildren()) {
            n = ((HCRow)this.m_aHead.getFirstChild()).getEffectiveCellCount();
        }
        if (n == 0 && this.m_aBody.hasChildren()) {
            n = ((HCRow)this.m_aBody.getFirstChild()).getEffectiveCellCount();
        }
        if (n == 0 && this.m_aFoot.hasChildren()) {
            n = ((HCRow)this.m_aFoot.getFirstChild()).getEffectiveCellCount();
        }
        Object object = "Table";
        if (StringHelper.hasText((String)this.getID())) {
            object = (String)object + " with ID " + this.getID();
        }
        AbstractHCBaseTable._checkConsistency((String)object + " header", this.m_aHead, n);
        AbstractHCBaseTable._checkConsistency((String)object + " body", this.m_aBody, n);
        AbstractHCBaseTable._checkConsistency((String)object + " footer", this.m_aFoot, n);
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.onConsistencyCheck(iHCConversionSettingsToNode);
        this.checkInternalConsistency();
    }

    @Override
    @Nonnull
    public final String getPlainText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_aHead.getPlainText());
        stringBuilder.append(this.m_aBody.getPlainText());
        stringBuilder.append(this.m_aFoot.getPlainText());
        return stringBuilder.toString();
    }

    @Override
    public final void forAllChildren(@Nonnull Consumer<? super IHCNode> consumer) {
        this.m_aHead.forAllChildren(consumer);
        this.m_aBody.forAllChildren(consumer);
        this.m_aFoot.forAllChildren(consumer);
    }

    @Override
    @Nonnull
    public final EContinue forAllChildrenBreakable(@Nonnull Function<? super IHCNode, EContinue> function) {
        if (this.m_aHead.forAllChildrenBreakable(function).isBreak()) {
            return EContinue.BREAK;
        }
        if (this.m_aBody.forAllChildrenBreakable(function).isBreak()) {
            return EContinue.BREAK;
        }
        if (this.m_aFoot.forAllChildrenBreakable(function).isBreak()) {
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    @Override
    public final void forAllChildren(@Nonnull Predicate<? super IHCNode> predicate, @Nonnull Consumer<? super IHCNode> consumer) {
        this.m_aHead.forAllChildren(predicate, consumer);
        this.m_aBody.forAllChildren(predicate, consumer);
        this.m_aFoot.forAllChildren(predicate, consumer);
    }

    @Override
    public <DSTTYPE> void forAllChildrenMapped(@Nonnull Predicate<? super IHCNode> predicate, @Nonnull Function<? super IHCNode, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        this.m_aHead.forAllChildrenMapped(predicate, function, consumer);
        this.m_aBody.forAllChildrenMapped(predicate, function, consumer);
        this.m_aFoot.forAllChildrenMapped(predicate, function, consumer);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("ColGroup", (Object)this.m_aColGroup).append("CellSpacing", this.m_nCellSpacing).append("CellPadding", this.m_nCellPadding).append("Header", (Object)this.m_aHead).append("Body", (Object)this.m_aBody).append("Footer", (Object)this.m_aFoot).getToString();
    }
}

