/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.tabular;

import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.html.AbstractHCElementWithInternalChildren;
import com.helger.html.hc.html.tabular.IHCCol;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HCColGroup
extends AbstractHCElementWithInternalChildren<HCColGroup, IHCCol<?>> {
    public HCColGroup() {
        super(EHTMLElement.COLGROUP);
    }

    @Nonnull
    public final HCColGroup addColumns(IHCCol<?> ... iHCColArray) {
        if (iHCColArray != null) {
            for (IHCCol<?> iHCCol : iHCColArray) {
                this.addColumn(iHCCol);
            }
        }
        return this;
    }

    @Nonnull
    public final HCColGroup addColumns(@Nullable Iterable<? extends IHCCol<?>> iterable) {
        if (iterable != null) {
            for (IHCCol<?> iHCCol : iterable) {
                this.addColumn(iHCCol);
            }
        }
        return this;
    }

    @Nonnull
    public final HCColGroup addColumn(@Nullable IHCCol<?> iHCCol) {
        if (iHCCol != null) {
            this.addChild(iHCCol);
        }
        return this;
    }

    @Nonnull
    public final HCColGroup addColumnAt(@Nonnegative int n, @Nullable IHCCol<?> iHCCol) {
        if (iHCCol != null) {
            this.addChildAt(n, iHCCol);
        }
        return this;
    }

    public final boolean hasColumns() {
        return this.hasChildren();
    }

    public final boolean hasNoColumns() {
        return this.hasNoChildren();
    }

    @Nonnegative
    public final int getColumnCount() {
        return this.getChildCount();
    }

    @Nonnull
    @ReturnsImmutableObject
    public final ICommonsList<IHCCol<?>> getAllColumns() {
        return this.getAllChildren();
    }

    @Nullable
    public final IHCCol<?> getColumnOfIndex(int n) {
        return (IHCCol)this.getChildAtIndex(n);
    }

    @Nonnull
    public final HCColGroup removeColumnAt(int n) {
        this.removeChildAt(n);
        return this;
    }

    @Nonnull
    public final HCColGroup removeAllColumns() {
        return (HCColGroup)this.removeAllChildren();
    }
}

