/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.html.textlevel;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.config.HCConsistencyChecker;
import com.helger.html.hc.html.AbstractHCElementWithChildren;
import com.helger.html.hc.html.HCHTMLHelper;
import com.helger.html.hc.html.HC_Target;
import com.helger.html.hc.html.links.EHCReferrerPolicy;
import com.helger.html.hc.html.textlevel.IHCA;
import com.helger.xml.microdom.IHasAttributeValue;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractHCA<IMPLTYPE extends AbstractHCA<IMPLTYPE>>
extends AbstractHCElementWithChildren<IMPLTYPE>
implements IHCA<IMPLTYPE> {
    private String m_sName;
    private ISimpleURL m_aHref;
    private HC_Target m_aTarget;
    private String m_sDownload;
    private ISimpleURL m_aPing;
    private String m_sRel;
    private IMimeType m_aType;
    private EHCReferrerPolicy m_eReferrerPolicy;
    private String m_sMediaQuery;

    public AbstractHCA() {
        super(EHTMLElement.A);
    }

    public AbstractHCA(@Nonnull ISimpleURL iSimpleURL) {
        this();
        this.setHref(iSimpleURL);
    }

    @Override
    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setName(@Nullable String string) {
        this.m_sName = string;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getHref() {
        return this.m_aHref;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHref(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"href");
        this.m_aHref = iSimpleURL;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final HC_Target getTarget() {
        return this.m_aTarget;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setTarget(@Nullable HC_Target hC_Target) {
        this.m_aTarget = hC_Target;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getDownload() {
        return this.m_sDownload;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setDownload(@Nullable String string) {
        this.m_sDownload = string;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final ISimpleURL getPing() {
        return this.m_aPing;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setPing(@Nullable ISimpleURL iSimpleURL) {
        this.m_aPing = iSimpleURL;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getRel() {
        return this.m_sRel;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setRel(@Nullable String string) {
        this.m_sRel = string;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final IMimeType getType() {
        return this.m_aType;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setType(@Nullable IMimeType iMimeType) {
        this.m_aType = iMimeType;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final EHCReferrerPolicy getReferrerPolicy() {
        return this.m_eReferrerPolicy;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setReferrerPolicy(@Nullable EHCReferrerPolicy eHCReferrerPolicy) {
        this.m_eReferrerPolicy = eHCReferrerPolicy;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    @Nullable
    public final String getMedia() {
        return this.m_sMediaQuery;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMedia(@Nullable String string) {
        this.m_sMediaQuery = string;
        return (IMPLTYPE)((AbstractHCA)this.thisAsT());
    }

    @Override
    protected void onConsistencyCheck(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        super.onConsistencyCheck(iHCConversionSettingsToNode);
        if (HCHTMLHelper.recursiveContainsChildWithTagName(this, EHTMLElement.A)) {
            HCConsistencyChecker.consistencyError("<A> may never contain other links!");
        }
        if (HCHTMLHelper.recursiveContainsChildWithTagName(this, EHTMLElement.SELECT)) {
            HCConsistencyChecker.consistencyError("<A> contains invalid child element!");
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void fillMicroElement(IMicroElement iMicroElement, IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        String string;
        super.fillMicroElement(iMicroElement, iHCConversionSettingsToNode);
        if (StringHelper.hasText((String)this.m_sName)) {
            iMicroElement.setAttribute(CHTMLAttributes.NAME, this.m_sName);
        }
        if (this.m_aHref != null) {
            string = this.m_aHref.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset());
            iMicroElement.setAttribute(CHTMLAttributes.HREF, string);
        }
        if (this.m_aTarget != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TARGET, (IHasAttributeValue)this.m_aTarget);
        }
        if (StringHelper.hasText((String)this.m_sDownload)) {
            iMicroElement.setAttribute(CHTMLAttributes.DOWNLOAD, this.m_sDownload);
        }
        if (this.m_aPing != null) {
            string = this.m_aPing.getAsStringWithEncodedParameters(iHCConversionSettingsToNode.getCharset());
            iMicroElement.setAttribute(CHTMLAttributes.PING, string);
        }
        if (StringHelper.hasText((String)this.m_sRel)) {
            iMicroElement.setAttribute(CHTMLAttributes.REL, this.m_sRel);
        }
        if (this.m_aType != null) {
            iMicroElement.setAttribute(CHTMLAttributes.TYPE, this.m_aType.getAsString());
        }
        if (this.m_eReferrerPolicy != null) {
            iMicroElement.setAttribute(CHTMLAttributes.REFERRERPOLICY, (IHasAttributeValue)this.m_eReferrerPolicy);
        }
        if (StringHelper.hasText((String)this.m_sMediaQuery)) {
            iMicroElement.setAttribute(CHTMLAttributes.MEDIA, this.m_sMediaQuery);
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("Name", (Object)this.m_sName).appendIfNotNull("Href", (Object)this.m_aHref).appendIfNotNull("Target", (Object)this.m_aTarget).appendIfNotNull("Download", (Object)this.m_sDownload).appendIfNotNull("Ping", (Object)this.m_aPing).appendIfNotNull("Rel", (Object)this.m_sRel).appendIfNotNull("Type", (Object)this.m_aType).appendIfNotNull("ReferrerPolicy", (Object)this.m_eReferrerPolicy).appendIfNotNull("MediaQuery", (Object)this.m_sMediaQuery).getToString();
    }
}

