/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.impl.AbstractHCNode;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.util.MicroRecursiveIterator;
import javax.annotation.Nonnull;

public class HCDOMWrapper
extends AbstractHCNode {
    private final IMicroNode m_aNode;

    public HCDOMWrapper(@Nonnull IMicroNode iMicroNode) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        ValueEnforcer.isTrue((!iMicroNode.hasParent() ? 1 : 0) != 0, (String)"Passed MicroNode may not have a parent!");
        this.m_aNode = iMicroNode;
    }

    @Nonnull
    public IMicroNode getNode() {
        return this.m_aNode;
    }

    @Override
    @Nonnull
    protected IMicroNode internalConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return (IMicroNode)this.m_aNode.getClone();
    }

    @Override
    @Nonnull
    public String getPlainText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IMicroNode iMicroNode : new MicroRecursiveIterator(this.m_aNode)) {
            IMicroText iMicroText;
            CharSequence charSequence = null;
            EMicroNodeType eMicroNodeType = iMicroNode.getType();
            if (eMicroNodeType == EMicroNodeType.TEXT) {
                iMicroText = (IMicroText)iMicroNode;
                if (!iMicroText.isElementContentWhitespace()) {
                    charSequence = iMicroText.getData();
                }
            } else if (eMicroNodeType == EMicroNodeType.CDATA) {
                iMicroText = (IMicroCDATA)iMicroNode;
                charSequence = iMicroText.getData();
            }
            if (!StringHelper.hasText(charSequence)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(charSequence);
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("node", (Object)this.m_aNode).getToString();
    }
}

