/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.hc.render;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.html.EHTMLVersion;
import com.helger.html.hc.HCHelper;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCCustomizer;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCIteratorNonBreakableCallback;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.root.HCHtml;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HCRenderer {
    private HCRenderer() {
    }

    @Nonnull
    public static <T extends IHCNode> T getPreparedNode(@Nonnull T t, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        t.customizeNode(iHCConversionSettingsToNode.getCustomizer(), iHCConversionSettingsToNode.getHTMLVersion(), iHCHasChildrenMutable);
        t.finalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        t.consistencyCheck(iHCConversionSettingsToNode);
        t.registerExternalResources(iHCConversionSettingsToNode, false);
        return t;
    }

    public static void prepareHtmlForConversion(@Nonnull HCHtml hCHtml, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        HCRenderer.prepareForConversion(hCHtml, hCHtml.body(), iHCConversionSettingsToNode);
        if (iHCConversionSettingsToNode.isExtractOutOfBandNodes()) {
            ICommonsList<IHCNode> iCommonsList = hCHtml.getAllOutOfBandNodesWithMergedInlineNodes();
            hCHtml.addAllOutOfBandNodesToHead((List<IHCNode>)iCommonsList);
        }
        if (HCSettings.isScriptsInBody()) {
            hCHtml.moveScriptElementsToBody();
        }
    }

    public static void prepareForConversion(@Nonnull IHCNode iHCNode3, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        ValueEnforcer.notNull((Object)iHCNode3, (String)"NodeToBeCustomized");
        ValueEnforcer.notNull(iHCHasChildrenMutable, (String)"TargetNode");
        ValueEnforcer.notNull((Object)iHCConversionSettingsToNode, (String)"ConversionSettings");
        IHCCustomizer iHCCustomizer = iHCConversionSettingsToNode.getCustomizer();
        EHTMLVersion eHTMLVersion = iHCConversionSettingsToNode.getHTMLVersion();
        IHCIteratorNonBreakableCallback iHCIteratorNonBreakableCallback = (iHCNode, iHCNode2) -> {
            IHCHasChildrenMutable iHCHasChildrenMutable2 = iHCNode instanceof IHCHasChildrenMutable ? (IHCHasChildrenMutable)GenericReflection.uncheckedCast((Object)iHCNode) : iHCHasChildrenMutable;
            int n = iHCHasChildrenMutable2.getChildCount();
            iHCNode2.customizeNode(iHCCustomizer, eHTMLVersion, iHCHasChildrenMutable2);
            iHCNode2.finalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable2);
            iHCNode2.consistencyCheck(iHCConversionSettingsToNode);
            boolean bl = false;
            iHCNode2.registerExternalResources(iHCConversionSettingsToNode, false);
            if (iHCHasChildrenMutable2.getChildCount() > n) {
                HCRenderer.prepareForConversion(iHCHasChildrenMutable2, iHCHasChildrenMutable2, iHCConversionSettingsToNode);
            }
        };
        HCHelper.iterateTreeNonBreakable(iHCNode3, iHCIteratorNonBreakableCallback);
    }

    @Nullable
    public static IMicroNode getAsNode(@Nonnull IHCNode iHCNode) {
        return HCRenderer.getAsNode(iHCNode, HCSettings.getConversionSettings());
    }

    @Nullable
    public static IMicroNode getAsNode(@Nonnull IHCNode iHCNode, @Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        IHCNode iHCNode2 = iHCNode;
        if (!(iHCNode instanceof HCHtml)) {
            IHCHasChildrenMutable iHCHasChildrenMutable;
            boolean bl = iHCNode instanceof IHCHasChildrenMutable;
            if (bl) {
                iHCHasChildrenMutable = (IHCHasChildrenMutable)iHCNode;
            } else {
                iHCHasChildrenMutable = new HCNodeList();
                iHCHasChildrenMutable.addChild(iHCNode);
            }
            HCRenderer.prepareForConversion(iHCHasChildrenMutable, iHCHasChildrenMutable, iHCConversionSettingsToNode);
            if (!bl && iHCHasChildrenMutable.getChildCount() > 1) {
                iHCNode2 = iHCHasChildrenMutable;
            }
        }
        return iHCNode2.convertToMicroNode(iHCConversionSettingsToNode);
    }

    @Nonnull
    public static String getAsHTMLString(@Nonnull IHCNode iHCNode) {
        return HCRenderer.getAsHTMLString(iHCNode, HCSettings.getConversionSettings());
    }

    @Nonnull
    public static String getAsHTMLString(@Nonnull IHCNode iHCNode, @Nonnull IHCConversionSettings iHCConversionSettings) {
        IMicroNode iMicroNode = HCRenderer.getAsNode(iHCNode, iHCConversionSettings);
        if (iMicroNode == null) {
            return "";
        }
        return MicroWriter.getNodeAsString((IMicroNode)iMicroNode, (IXMLWriterSettings)iHCConversionSettings.getXMLWriterSettings());
    }

    @Nonnull
    public static String getAsHTMLStringWithoutNamespaces(@Nonnull IHCNode iHCNode) {
        return HCRenderer.getAsHTMLString(iHCNode, HCSettings.getConversionSettingsWithoutNamespaces());
    }

    @Deprecated(forRemoval=true, since="9.3.0")
    public static void writeHtmlTo(@Nonnull IHCNode iHCNode, @Nonnull OutputStream outputStream) {
        HCRenderer.writeHtmlTo(iHCNode, HCSettings.getConversionSettings(), outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHtmlTo(@Nonnull IHCNode iHCNode, @Nonnull IHCConversionSettings iHCConversionSettings, @Nonnull @WillClose OutputStream outputStream) {
        try {
            IMicroNode iMicroNode = HCRenderer.getAsNode(iHCNode, iHCConversionSettings);
            if (iMicroNode != null) {
                MicroWriter.writeToStream((IMicroNode)iMicroNode, (OutputStream)outputStream, (IXMLWriterSettings)iHCConversionSettings.getXMLWriterSettings());
            }
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }
}

