/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.html.js.EJSEventType;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EJSEvent {
    BLUR("blur", EJSEventType.WINDOW, EJSEventType.FORM),
    ERROR("error", EJSEventType.WINDOW, EJSEventType.MEDIA),
    FOCUS("focus", EJSEventType.WINDOW, EJSEventType.FORM),
    LOAD("load", EJSEventType.WINDOW),
    RESIZE("resize", EJSEventType.WINDOW),
    SCROLL("scroll", EJSEventType.MOUSE),
    AFTERPRINT("afterprint", EJSEventType.WINDOW),
    BEFOREPRINT("beforeprint", EJSEventType.WINDOW),
    BEFOREUNLOAD("beforeunload", EJSEventType.WINDOW),
    HASHCHANGE("hashchange", EJSEventType.WINDOW),
    MESSAGE("message", EJSEventType.WINDOW),
    OFFLINE("offline", EJSEventType.WINDOW),
    ONLINE("online", EJSEventType.WINDOW),
    PAGEHIDE("pagehide", EJSEventType.WINDOW),
    PAGESHOW("pageshow", EJSEventType.WINDOW),
    POPSTATE("popstate", EJSEventType.WINDOW),
    STORAGE("storage", EJSEventType.WINDOW),
    UNLOAD("unload", EJSEventType.WINDOW),
    READYSTATECHANGE("readystatechange", EJSEventType.MEDIA),
    CHANGE("change", EJSEventType.FORM),
    CONTEXTMENU("contextmenu", EJSEventType.FORM),
    FORMCHANGE("formchange", EJSEventType.FORM),
    FORMINPUT("forminput", EJSEventType.FORM),
    INPUT("input", EJSEventType.FORM),
    INVALID("invalid", EJSEventType.FORM),
    SELECT("select", EJSEventType.FORM),
    SUBMIT("submit", EJSEventType.FORM),
    KEYDOWN("keydown", EJSEventType.KEYBOARD),
    KEYPRESS("keypress", EJSEventType.KEYBOARD),
    KEYUP("keyup", EJSEventType.KEYBOARD),
    CLICK("click", EJSEventType.MOUSE),
    DBLCLICK("dblclick", EJSEventType.MOUSE),
    DRAG("drag", EJSEventType.MOUSE),
    DRAGEND("dragend", EJSEventType.MOUSE),
    DRAGENTER("dragenter", EJSEventType.MOUSE),
    DRAGLEAVE("dragleave", EJSEventType.MOUSE),
    DRAGOVER("dragover", EJSEventType.MOUSE),
    DRAGSTART("dragstart", EJSEventType.MOUSE),
    DROP("drop", EJSEventType.MOUSE),
    MOUSEDOWN("mousedown", EJSEventType.MOUSE),
    MOUSEMOVE("mousemove", EJSEventType.MOUSE),
    MOUSEOUT("mouseout", EJSEventType.MOUSE),
    MOUSEOVER("mouseover", EJSEventType.MOUSE),
    MOUSEUP("mouseup", EJSEventType.MOUSE),
    MOUSEWHEEL("mousewheel", EJSEventType.MOUSE),
    ABORT("abort", EJSEventType.MEDIA),
    CANPLAY("canplay", EJSEventType.MEDIA),
    CANPLAYTHROUGH("canplaythrough", EJSEventType.MEDIA),
    DURATIONCHANGE("durationchange", EJSEventType.MEDIA),
    EMPTIED("emptied", EJSEventType.MEDIA),
    ENDED("ended", EJSEventType.MEDIA),
    LOADEDDATA("loadeddata", EJSEventType.MEDIA),
    LOADEDMETADATA("loadedmetadata", EJSEventType.MEDIA),
    LOADSTART("loadstart", EJSEventType.MEDIA),
    PAUSE("pause", EJSEventType.MEDIA),
    PLAY("play", EJSEventType.MEDIA),
    PLAYING("playing", EJSEventType.MEDIA),
    PROGRESS("progress", EJSEventType.MEDIA),
    RATECHANGE("ratechange", EJSEventType.MEDIA),
    SEEKEND("seekend", EJSEventType.MEDIA),
    SEEKING("seeking", EJSEventType.MEDIA),
    STALLED("stalled", EJSEventType.MEDIA),
    SUSPEND("suspend", EJSEventType.MEDIA),
    TIMEUPDATE("timeupdate", EJSEventType.MEDIA),
    VOLUMECHANGE("volumechange", EJSEventType.MEDIA),
    WAITING("waiting", EJSEventType.MEDIA),
    TOUCHSTART("touchstart", EJSEventType.TOUCH),
    TOUCHMOVE("touchmove", EJSEventType.TOUCH),
    TOUCHEND("touchend", EJSEventType.TOUCH),
    GESTURESTART("gesturestart", EJSEventType.TOUCH),
    GESTUREMOVE("gesturemove", EJSEventType.TOUCH),
    GESTUREEND("gestureend", EJSEventType.TOUCH),
    POINTEROVER("pointerover", EJSEventType.POINTER),
    POINTERENTER("pointerenter", EJSEventType.POINTER),
    POINTERDOWN("pointerdown", EJSEventType.POINTER),
    POINTERMOVE("pointermove", EJSEventType.POINTER),
    POINTERUP("pointerup", EJSEventType.POINTER),
    POINTERCANCEL("pointercancel", EJSEventType.POINTER),
    POINTEROUT("pointerout", EJSEventType.POINTER),
    POINTERLEAVE("pointerleave", EJSEventType.POINTER),
    GOTPOINTERCAPTURE("gotpointercapture", EJSEventType.POINTER),
    LOSTPOINTERCAPTURE("lostpointercapture", EJSEventType.POINTER),
    CANCEL("cancel", EJSEventType.FORM),
    CUECHANGE("cuechange", EJSEventType.FORM);

    private final String m_sEvent;
    @CodingStyleguideUnaware
    private final Set<EJSEventType> m_aJSEventTypes;

    private EJSEvent(String string2, EJSEventType ... eJSEventTypeArray) {
        this.m_sEvent = string2;
        this.m_aJSEventTypes = new CommonsHashSet((Object[])eJSEventTypeArray).getAsUnmodifiable();
    }

    @Nonnull
    @Nonempty
    public String getJSEventName() {
        return this.m_sEvent;
    }

    @Nonnull
    @Nonempty
    public String getHTMLEventName() {
        return "on" + this.m_sEvent;
    }

    @Nonnull
    @Nonempty
    @ReturnsImmutableObject
    @CodingStyleguideUnaware
    public Set<EJSEventType> getAllTypes() {
        return this.m_aJSEventTypes;
    }

    public boolean isForType(@Nullable EJSEventType eJSEventType) {
        return this.m_aJSEventTypes.contains((Object)eJSEventType);
    }
}

