/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.meta;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.html.meta.EMetaElementType;
import com.helger.html.meta.IMetaElementDeclaration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EDublinCoreMetaElement implements IMetaElementDeclaration
{
    TITLE("DC.title"),
    CREATOR("DC.creator"),
    SUBJECT("DC.subject"),
    DESCRIPTION("DC.description"),
    PUBLISHER("DC.publisher"),
    CONTRIBUTOR("DC.contributor"),
    DATE("DC.date", "DCTERMS.W3CDTF"),
    TYPE("DC.type", "DCTERMS.DCMIType"),
    FORMAT("DC.format", "DCTERMS.IMT"),
    IDENTIFIER("DC.identifier", "DCTERMS.URI"),
    SOURCE("DC.source", "DCTERMS.URI"),
    LANGUAGE("DC.language", "DCTERMS.RFC3066"),
    RELATION("DC.relation", "DCTERMS.URI"),
    COVERAGE("DC.coverage", "DCTERMS.TGN"),
    RIGHTS("DC.rights");

    private final String m_sName;
    private final String m_sScheme;

    private EDublinCoreMetaElement(String string2) {
        this(string2, null);
    }

    private EDublinCoreMetaElement(String string2, String string3) {
        this.m_sName = string2;
        this.m_sScheme = string3;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public String getScheme() {
        return this.m_sScheme;
    }

    @Override
    @Nonnull
    public EMetaElementType getType() {
        return EMetaElementType.DOCUMENT_LEVEL;
    }

    @Nullable
    public static EDublinCoreMetaElement getDCMetaTag(@Nullable String string) {
        return (EDublinCoreMetaElement)EnumHelper.getFromNameOrNull(EDublinCoreMetaElement.class, (String)string);
    }

    public static boolean isDCMetaTag(@Nullable String string) {
        return EDublinCoreMetaElement.getDCMetaTag(string) != null;
    }
}

