/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.meta;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.html.meta.EMetaElementType;
import com.helger.html.meta.IMetaElement;
import com.helger.html.meta.IMetaElementDeclaration;
import com.helger.html.meta.MetaElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EStandardMetaElement implements IMetaElementDeclaration
{
    CONTENT_TYPE("Content-Type", true),
    CONTENT_SCRIPT_TYPE("Content-Script-Type", true),
    CONTENT_SECURITY_POLICY("Content-Security-Policy", true),
    CONTENT_STYLE_TYPE("Content-Style-Type", true),
    CONTENT_DISPOSITION("Content-Disposition", true),
    EXPIRES("Expires", true),
    PRAGMA("Pragma", true),
    DEFAULT_STYLE("Default-Style", true),
    CONTENT_LANGUAGE("Content-Language", true),
    REFRESH("Refresh", true),
    WINDOW_TARGET("Window-target", true),
    EXT_CACHE("Ext-cache", true),
    SET_COOKIE("Set-Cookie", true),
    PICS_LABEL("PICS-Label", true),
    CACHE_CONTROL("Cache-Control", true),
    VARY("Vary", true),
    X_UA_COMPATIBLE("X-UA-Compatible", true),
    DESCRIPTION("Description", false),
    KEYWORDS("Keywords", false),
    AUTHOR("Author", false),
    COPYRIGHT("Copyright", false),
    LANGUAGE("Language", false),
    VIEWPORT("viewport", false),
    GENERATOR("generator", false),
    APPLICATION_NAME("application-name", false),
    MSAPPLICATION_ALLOW_DOMAIN_API_CALLS("msapplication-allowDomainApiCalls", false),
    MSAPPLICATION_ALLOW_DOMAIN_META_TAGS("msapplication-allowDomainMetaTags", false),
    MSAPPLICATION_BADGE("msapplication-badge", false),
    MSAPPLICATION_CONFIG("msapplication-config", false),
    MSAPPLICATION_NAVBUTTON_COLOR("msapplication-navbutton-color", false),
    MSAPPLICATION_NOTIFICATION("msapplication-notification", false),
    MSAPPLICATION_SQUARE_150X150_LOGO("msapplication-square150x150logo", false),
    MSAPPLICATION_SQUARE_310X310_LOGO("msapplication-square310x310logo", false),
    MSAPPLICATION_SQUARE_70X70_LOGO("msapplication-square70x70logo", false),
    MSAPPLICATION_WIDE_310X150_LOGO("msapplication-wide310x150logo", false),
    MSAPPLICATION_STARTURL("msapplication-starturl", false),
    MSAPPLICATION_TASK("msapplication-task", false),
    MSAPPLICATION_TASK_SEPARATOR("msapplication-task-separator", false),
    MSAPPLICATION_TILE_COLOR("msapplication-TileColor", false),
    MSAPPLICATION_TILE_IMAGE("msapplication-TileImage", false),
    MSAPPLICATION_TOOLTIP("msapplication-tooltip", false),
    MSAPPLICATION_WINDOW("msapplication-window", false),
    FORMAT_DETECTION("format-detection", false);

    private final String m_sName;
    private final EMetaElementType m_eType;

    private EStandardMetaElement(String string2, boolean bl) {
        this.m_sName = string2;
        this.m_eType = bl ? EMetaElementType.PRAGMA_DIRECTIVE : EMetaElementType.DOCUMENT_LEVEL;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public String getScheme() {
        return null;
    }

    @Override
    @Nonnull
    public EMetaElementType getType() {
        return this.m_eType;
    }

    @Nonnull
    public IMetaElement getAsMetaElement(@Nullable String string) {
        return new MetaElement(this.getType(), this.m_sName, null, null, string);
    }

    @Nullable
    public static EStandardMetaElement getStandardElementOfNameOrNull(@Nullable String string) {
        return (EStandardMetaElement)EnumHelper.getFromNameOrNull(EStandardMetaElement.class, (String)string);
    }

    @Nullable
    public static EStandardMetaElement getStandardElementOfNameOrNullIgnoreCase(@Nullable String string) {
        return (EStandardMetaElement)EnumHelper.getFromNameCaseInsensitiveOrNull(EStandardMetaElement.class, (String)string);
    }
}

