/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.binding;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.exception.InitializationException;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.SchematronBindException;
import com.helger.schematron.pure.binding.xpath.PSXPathQueryBinding;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@ThreadSafe
public final class PSQueryBindingRegistry {
    public static final String QUERY_BINDING_XSLT = "xslt";
    public static final String QUERY_BINDING_XSLT2 = "xslt2";
    public static final String QUERY_BINDING_XSLT3 = "xslt3";
    public static final String QUERY_BINDING_XPATH = "xpath";
    public static final String QUERY_BINDING_XPATH2 = "xpath2";
    public static final String QUERY_BINDING_XPATH3 = "xpath3";
    public static final String QUERY_BINDING_EXSLT = "exslt";
    public static final String QUERY_BINDING_STX = "stx";
    public static final IPSQueryBinding DEFAULT_QUERY_BINDING = PSXPathQueryBinding.getInstance();
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final ICommonsMap<String, IPSQueryBinding> s_aMap = new CommonsHashMap();
    private static final PSQueryBindingRegistry INSTANCE;

    private PSQueryBindingRegistry() {
    }

    public static void registerQueryBinding(@Nonnull @Nonempty String string, @Nonnull IPSQueryBinding iPSQueryBinding) throws SchematronBindException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)iPSQueryBinding, (String)"QueryBinding");
        RW_LOCK.writeLockedThrowing(() -> {
            if (s_aMap.containsKey((Object)string)) {
                throw new SchematronBindException("A queryBinding with the name '" + string + "' is already registered!");
            }
            s_aMap.put((Object)string, (Object)iPSQueryBinding);
        });
    }

    @Nullable
    public static IPSQueryBinding getQueryBindingOfName(@Nullable String string) {
        if (string == null) {
            return DEFAULT_QUERY_BINDING;
        }
        return (IPSQueryBinding)RW_LOCK.readLockedGet(() -> (IPSQueryBinding)s_aMap.get((Object)string));
    }

    @Nonnull
    public static IPSQueryBinding getQueryBindingOfNameOrThrow(@Nullable String string) throws SchematronBindException {
        IPSQueryBinding iPSQueryBinding = PSQueryBindingRegistry.getQueryBindingOfName(string);
        if (iPSQueryBinding == null) {
            throw new SchematronBindException("No query binding implementation present for query binding '" + string + "'");
        }
        return iPSQueryBinding;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, IPSQueryBinding> getAllRegisteredQueryBindings() {
        return (ICommonsMap)RW_LOCK.readLockedGet(() -> s_aMap.getClone());
    }

    static {
        try {
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XPATH, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XPATH2, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XPATH3, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XSLT, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XSLT2, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XSLT3, DEFAULT_QUERY_BINDING);
        }
        catch (SchematronBindException schematronBindException) {
            throw new InitializationException((Throwable)((Object)schematronBindException));
        }
        INSTANCE = new PSQueryBindingRegistry();
    }
}

