/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.binding.xpath;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.schematron.pure.binding.xpath.IPSXPathVariables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import javax.xml.xpath.XPathExpression;

@NotThreadSafe
public class PSXPathVariables
implements IPSXPathVariables {
    private final ICommonsOrderedMap<String, XPathExpression> m_aMap;

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsOrderedMap<String, XPathExpression> _createMap() {
        return new CommonsLinkedHashMap();
    }

    public PSXPathVariables() {
        this.m_aMap = PSXPathVariables._createMap();
    }

    public PSXPathVariables(@Nonnull IPSXPathVariables iPSXPathVariables) {
        this.m_aMap = iPSXPathVariables.getAll();
    }

    @Nonnull
    public EChange add(@Nonnull Map.Entry<String, XPathExpression> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public EChange add(@Nonnull @Nonempty String string, @Nonnull @Nonempty XPathExpression xPathExpression) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)xPathExpression, (String)"Value");
        if (this.m_aMap.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put((Object)string, (Object)xPathExpression);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange remove(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string) && this.m_aMap.remove((Object)("$" + string)) == null) {
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    public EChange removeAll(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or((IChangeIndicator)this.remove(string));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, XPathExpression> getAll() {
        return this.m_aMap.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllNames() {
        return this.m_aMap.copyOfKeySet();
    }

    @Override
    public boolean contains(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return this.m_aMap.containsKey((Object)string);
    }

    @Override
    @Nullable
    public XPathExpression get(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (XPathExpression)this.m_aMap.get((Object)string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public PSXPathVariables getClone() {
        return new PSXPathVariables(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).getToString();
    }
}

