/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.model.PSDiagnostic;
import jakarta.annotation.Nonnull;

@Immutable
public class PSXPathBoundDiagnostic {
    private final PSDiagnostic m_aDiagnostic;
    private final ICommonsList<PSXPathBoundElement> m_aBoundContent;

    public PSXPathBoundDiagnostic(@Nonnull PSDiagnostic pSDiagnostic, @Nonnull ICommonsList<PSXPathBoundElement> iCommonsList) {
        ValueEnforcer.notNull((Object)pSDiagnostic, (String)"Diagnostic");
        ValueEnforcer.notNull(iCommonsList, (String)"BoundContent");
        this.m_aDiagnostic = pSDiagnostic;
        this.m_aBoundContent = iCommonsList;
    }

    @Nonnull
    public PSDiagnostic getDiagnostic() {
        return this.m_aDiagnostic;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSXPathBoundElement> getAllBoundContentElements() {
        return (ICommonsList)this.m_aBoundContent.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Diagnostic", (Object)this.m_aDiagnostic).append("BoundContent", this.m_aBoundContent).getToString();
    }
}

