/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.schematron.pure.binding.xpath.PSXPathVariables;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundRule;
import com.helger.schematron.pure.model.PSPattern;
import jakarta.annotation.Nonnull;

@Immutable
public class PSXPathBoundPattern {
    private final PSPattern m_aPattern;
    private final ICommonsList<PSXPathBoundRule> m_aBoundRules;
    private final PSXPathVariables m_aVariables;

    public PSXPathBoundPattern(@Nonnull PSPattern pSPattern, @Nonnull ICommonsList<PSXPathBoundRule> iCommonsList, @Nonnull PSXPathVariables pSXPathVariables) {
        ValueEnforcer.notNull((Object)pSPattern, (String)"Pattern");
        ValueEnforcer.notNull(iCommonsList, (String)"BoundRules");
        ValueEnforcer.notNull((Object)pSXPathVariables, (String)"Variables");
        this.m_aPattern = pSPattern;
        this.m_aBoundRules = iCommonsList;
        this.m_aVariables = pSXPathVariables;
    }

    @Nonnull
    public PSPattern getPattern() {
        return this.m_aPattern;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSXPathBoundRule> getAllBoundRules() {
        return (ICommonsList)this.m_aBoundRules.getClone();
    }

    @Nonnull
    public final PSXPathVariables getVariables() {
        return this.m_aVariables;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Pattern", (Object)this.m_aPattern).append("BoundRules", this.m_aBoundRules).append("Variables", (Object)this.m_aVariables).getToString();
    }
}

