/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.exchange;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.schematron.pure.exchange.IPSWriterSettings;
import com.helger.schematron.pure.model.PSNS;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import jakarta.annotation.Nonnull;

public class PSWriterSettings
implements ICloneable<PSWriterSettings>,
IPSWriterSettings {
    public static final IPSWriterSettings DEFAULT_SETTINGS = new PSWriterSettings().setXMLWriterSettings((IXMLWriterSettings)new XMLWriterSettings().setIndent(EXMLSerializeIndent.NONE));
    private IXMLWriterSettings m_aXMLWriterSettings = new XMLWriterSettings();

    public PSWriterSettings() {
    }

    public PSWriterSettings(@Nonnull IPSWriterSettings iPSWriterSettings) {
        ValueEnforcer.notNull((Object)iPSWriterSettings, (String)"Other");
        this.m_aXMLWriterSettings = iPSWriterSettings.getXMLWriterSettings();
    }

    @Nonnull
    public IPSWriterSettings setXMLWriterSettings(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"XMLWriterSettings");
        this.m_aXMLWriterSettings = new XMLWriterSettings(iXMLWriterSettings);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public XMLWriterSettings getXMLWriterSettings() {
        return new XMLWriterSettings(this.m_aXMLWriterSettings);
    }

    @Nonnull
    public PSWriterSettings getClone() {
        return new PSWriterSettings(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("XMLWriterSettings", (Object)this.m_aXMLWriterSettings).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static MapBasedNamespaceContext createNamespaceMapping(@Nonnull PSSchema pSSchema) {
        MapBasedNamespaceContext mapBasedNamespaceContext = new MapBasedNamespaceContext();
        mapBasedNamespaceContext.addDefaultNamespaceURI("http://purl.oclc.org/dsdl/schematron");
        mapBasedNamespaceContext.addMapping("xsl", "http://www.w3.org/1999/XSL/Transform");
        for (PSNS pSNS : pSSchema.getAllNSs()) {
            mapBasedNamespaceContext.addMapping(pSNS.getPrefix(), pSNS.getUri());
        }
        return mapBasedNamespaceContext;
    }
}

