/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class PSInclude
implements IPSElement {
    private String m_sHref;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.isEmpty((String)this.m_sHref)) {
            iPSErrorHandler.error(this, "<include> has no 'href'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.isEmpty((String)this.m_sHref)) {
            iPSErrorHandler.error(this, "<include> has no 'href'");
        }
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    public void setHref(@Nullable String string) {
        this.m_sHref = string;
    }

    @Nullable
    public String getHref() {
        return this.m_sHref;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "include");
        microElement.setAttribute("href", this.m_sHref);
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("href", (Object)this.m_sHref).getToString();
    }
}

