/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.io.resource.IReadableResource;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSHasLets;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.PSDiagnostics;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSNS;
import com.helger.schematron.pure.model.PSP;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSTitle;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class PSSchema
implements IPSElement,
IPSHasID,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasRichGroup {
    private final IReadableResource m_aResource;
    private String m_sID;
    private PSRichGroup m_aRich;
    private String m_sSchemaVersion;
    private String m_sDefaultPhase;
    private String m_sQueryBinding;
    private PSTitle m_aTitle;
    private final ICommonsList<PSInclude> m_aIncludes = new CommonsArrayList();
    private final ICommonsList<PSNS> m_aNSs = new CommonsArrayList();
    private final ICommonsList<PSP> m_aStartPs = new CommonsArrayList();
    private final ICommonsList<PSLet> m_aLets = new CommonsArrayList();
    private final ICommonsList<PSPhase> m_aPhases = new CommonsArrayList();
    private final ICommonsList<PSPattern> m_aPatterns = new CommonsArrayList();
    private final ICommonsList<PSP> m_aEndPs = new CommonsArrayList();
    private PSDiagnostics m_aDiagnostics;
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;
    private ICommonsList<IMicroElement> m_aForeignElements;

    public PSSchema() {
        this(null);
    }

    public PSSchema(@Nullable IReadableResource iReadableResource) {
        this.m_aResource = iReadableResource;
    }

    @Nullable
    public IReadableResource getResource() {
        return this.m_aResource;
    }

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aPatterns.isEmpty()) {
            iPSErrorHandler.error(this, "<schema> has no <pattern>s");
            return false;
        }
        if (this.m_aTitle != null && !this.m_aTitle.isValid(iPSErrorHandler)) {
            return false;
        }
        for (IPSElement iPSElement : this.m_aIncludes) {
            if (((PSInclude)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aNSs) {
            if (((PSNS)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aStartPs) {
            if (((PSP)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aLets) {
            if (((PSLet)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aPhases) {
            if (((PSPhase)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aPatterns) {
            if (((PSPattern)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aEndPs) {
            if (((PSP)iPSElement).isValid(iPSErrorHandler)) continue;
            return false;
        }
        return this.m_aDiagnostics == null || this.m_aDiagnostics.isValid(iPSErrorHandler);
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aPatterns.isEmpty()) {
            iPSErrorHandler.error(this, "<schema> has no <pattern>s");
        }
        if (this.m_aTitle != null) {
            this.m_aTitle.validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aIncludes) {
            ((PSInclude)iPSElement).validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aNSs) {
            ((PSNS)iPSElement).validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aStartPs) {
            ((PSP)iPSElement).validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aLets) {
            ((PSLet)iPSElement).validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aPhases) {
            ((PSPhase)iPSElement).validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aPatterns) {
            ((PSPattern)iPSElement).validateCompletely(iPSErrorHandler);
        }
        for (IPSElement iPSElement : this.m_aEndPs) {
            ((PSP)iPSElement).validateCompletely(iPSErrorHandler);
        }
        if (this.m_aDiagnostics != null) {
            this.m_aDiagnostics.validateCompletely(iPSErrorHandler);
        }
    }

    public boolean isPreprocessed() {
        if (this.hasAnyInclude()) {
            return false;
        }
        for (IPSHasIncludes iPSHasIncludes : this.m_aPhases) {
            if (!((PSPhase)iPSHasIncludes).hasAnyInclude()) continue;
            return false;
        }
        for (IPSHasIncludes iPSHasIncludes : this.m_aPatterns) {
            if (((PSPattern)iPSHasIncludes).isAbstract() || ((PSPattern)iPSHasIncludes).hasAnyInclude() || ((PSPattern)iPSHasIncludes).hasAnyParam()) {
                return false;
            }
            for (PSRule pSRule : ((PSPattern)iPSHasIncludes).getAllRules()) {
                if (!pSRule.isAbstract() && !pSRule.hasAnyInclude() && !pSRule.hasAnyExtends()) continue;
                return false;
            }
        }
        return this.m_aDiagnostics == null || !this.m_aDiagnostics.hasAnyInclude();
    }

    @Override
    public boolean isMinimal() {
        if (this.m_aTitle != null && !this.m_aTitle.isMinimal()) {
            return false;
        }
        for (IPSElement iPSElement : this.m_aIncludes) {
            if (((PSInclude)iPSElement).isMinimal()) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aNSs) {
            if (((PSNS)iPSElement).isMinimal()) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aStartPs) {
            if (((PSP)iPSElement).isMinimal()) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aLets) {
            if (((PSLet)iPSElement).isMinimal()) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aPhases) {
            if (((PSPhase)iPSElement).isMinimal()) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aPatterns) {
            if (((PSPattern)iPSElement).isMinimal()) continue;
            return false;
        }
        for (IPSElement iPSElement : this.m_aEndPs) {
            if (((PSP)iPSElement).isMinimal()) continue;
            return false;
        }
        return this.m_aDiagnostics == null || this.m_aDiagnostics.isMinimal();
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new CommonsArrayList();
        }
        this.m_aForeignElements.add((Object)iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && this.m_aForeignElements.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return new CommonsArrayList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap();
        }
        this.m_aForeignAttrs.put((Object)string, (Object)string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap(this.m_aForeignAttrs);
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    public void setQueryBinding(@Nullable String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("queryBinding may not be empty!");
        }
        this.m_sQueryBinding = string;
    }

    @Nullable
    public String getQueryBinding() {
        return this.m_sQueryBinding;
    }

    public void setSchemaVersion(@Nullable String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("schemaVersion may not be empty!");
        }
        this.m_sSchemaVersion = string;
    }

    @Nullable
    public String getSchemaVersion() {
        return this.m_sSchemaVersion;
    }

    public void setDefaultPhase(@Nullable String string) {
        this.m_sDefaultPhase = string;
    }

    @Nullable
    public String getDefaultPhase() {
        return this.m_sDefaultPhase;
    }

    public void setTitle(@Nullable PSTitle pSTitle) {
        this.m_aTitle = pSTitle;
    }

    @Nullable
    public PSTitle getTitle() {
        return this.m_aTitle;
    }

    public boolean hasTitle() {
        return this.m_aTitle != null;
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull((Object)pSInclude, (String)"Include");
        this.m_aIncludes.add((Object)pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return this.m_aIncludes.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSInclude> getAllIncludes() {
        return (ICommonsList)this.m_aIncludes.getClone();
    }

    public void addNS(@Nonnull PSNS pSNS) {
        ValueEnforcer.notNull((Object)pSNS, (String)"NS");
        this.m_aNSs.add((Object)pSNS);
    }

    public boolean hasAnyNS() {
        return this.m_aNSs.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSNS> getAllNSs() {
        return (ICommonsList)this.m_aNSs.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public MapBasedNamespaceContext getAsNamespaceContext() {
        MapBasedNamespaceContext mapBasedNamespaceContext = new MapBasedNamespaceContext();
        for (PSNS pSNS : this.m_aNSs) {
            mapBasedNamespaceContext.addMapping(pSNS.getPrefix(), pSNS.getUri());
        }
        return mapBasedNamespaceContext;
    }

    public void addStartP(@Nonnull PSP pSP) {
        ValueEnforcer.notNull((Object)pSP, (String)"P");
        this.m_aStartPs.add((Object)pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSP> getAllStartPs() {
        return (ICommonsList)this.m_aStartPs.getClone();
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        ValueEnforcer.notNull((Object)pSLet, (String)"Let");
        this.m_aLets.add((Object)pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        return this.m_aLets.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSLet> getAllLets() {
        return (ICommonsList)this.m_aLets.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllLetsAsMap() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (PSLet pSLet : this.m_aLets) {
            commonsLinkedHashMap.put((Object)pSLet.getName(), (Object)pSLet.getValue());
        }
        return commonsLinkedHashMap;
    }

    public void addPhase(@Nonnull PSPhase pSPhase) {
        ValueEnforcer.notNull((Object)pSPhase, (String)"Phase");
        this.m_aPhases.add((Object)pSPhase);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSPhase> getAllPhases() {
        return (ICommonsList)this.m_aPhases.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllPhaseIDs() {
        return this.m_aPhases.getAllMapped(IPSHasID::hasID, PSPhase::getID);
    }

    @Nullable
    public PSPhase getPhaseOfID(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (PSPhase pSPhase : this.m_aPhases) {
                if (!string.equals(pSPhase.getID())) continue;
                return pSPhase;
            }
        }
        return null;
    }

    public void addPattern(@Nonnull PSPattern pSPattern) {
        ValueEnforcer.notNull((Object)pSPattern, (String)"Pattern");
        this.m_aPatterns.add((Object)pSPattern);
    }

    public boolean hasPatterns() {
        return this.m_aPatterns.isNotEmpty();
    }

    public boolean hasNoPatterns() {
        return this.m_aPatterns.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSPattern> getAllPatterns() {
        return (ICommonsList)this.m_aPatterns.getClone();
    }

    @Nonnegative
    public int getPatternCount() {
        return this.m_aPatterns.size();
    }

    @Nullable
    public PSPattern getPatternOfID(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (PSPattern pSPattern : this.m_aPatterns) {
                if (!string.equals(pSPattern.getID())) continue;
                return pSPattern;
            }
        }
        return null;
    }

    public void addEndP(@Nonnull PSP pSP) {
        ValueEnforcer.notNull((Object)pSP, (String)"P");
        this.m_aEndPs.add((Object)pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSP> getAllEndPs() {
        return (ICommonsList)this.m_aEndPs.getClone();
    }

    public void setDiagnostics(@Nullable PSDiagnostics pSDiagnostics) {
        this.m_aDiagnostics = pSDiagnostics;
    }

    public boolean hasDiagnostics() {
        return this.m_aDiagnostics != null;
    }

    @Nullable
    public PSDiagnostics getDiagnostics() {
        return this.m_aDiagnostics;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "schema");
        microElement.setAttribute("id", this.m_sID);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        microElement.setAttribute("schemaVersion", this.m_sSchemaVersion);
        microElement.setAttribute("defaultPhase", this.m_sDefaultPhase);
        microElement.setAttribute("queryBinding", this.m_sQueryBinding);
        if (this.m_aForeignElements != null) {
            for (Object object : this.m_aForeignElements) {
                microElement.addChild((IMicroNode)object.getClone());
            }
        }
        for (Object object : this.m_aIncludes) {
            microElement.addChild((IMicroNode)((PSInclude)object).getAsMicroElement());
        }
        if (this.m_aTitle != null) {
            microElement.addChild((IMicroNode)this.m_aTitle.getAsMicroElement());
        }
        for (Object object : this.m_aNSs) {
            microElement.addChild((IMicroNode)((PSNS)object).getAsMicroElement());
        }
        for (Object object : this.m_aStartPs) {
            microElement.addChild((IMicroNode)((PSP)object).getAsMicroElement());
        }
        for (Object object : this.m_aLets) {
            microElement.addChild((IMicroNode)((PSLet)object).getAsMicroElement());
        }
        for (Object object : this.m_aPhases) {
            microElement.addChild((IMicroNode)((PSPhase)object).getAsMicroElement());
        }
        for (Object object : this.m_aPatterns) {
            microElement.addChild((IMicroNode)((PSPattern)object).getAsMicroElement());
        }
        for (Object object : this.m_aEndPs) {
            microElement.addChild((IMicroNode)((PSP)object).getAsMicroElement());
        }
        if (this.m_aDiagnostics != null) {
            microElement.addChild((IMicroNode)this.m_aDiagnostics.getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Object object : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)object.getKey(), (String)object.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("resource", (Object)this.m_aResource).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("rich", (Object)this.m_aRich).appendIfNotNull("schemaVersion", (Object)this.m_sSchemaVersion).appendIfNotNull("defaultPhase", (Object)this.m_sDefaultPhase).appendIfNotNull("queryBinding", (Object)this.m_sQueryBinding).appendIfNotNull("title", (Object)this.m_aTitle).appendIf("includes", this.m_aIncludes, CollectionHelper::isNotEmpty).appendIf("nss", this.m_aNSs, CollectionHelper::isNotEmpty).appendIf("startps", this.m_aStartPs, CollectionHelper::isNotEmpty).appendIf("lets", this.m_aLets, CollectionHelper::isNotEmpty).appendIf("phases", this.m_aPhases, CollectionHelper::isNotEmpty).appendIf("patterns", this.m_aPatterns, CollectionHelper::isNotEmpty).appendIf("endps", this.m_aEndPs, CollectionHelper::isNotEmpty).appendIfNotNull("diagnostics", (Object)this.m_aDiagnostics).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).appendIf("foreignElements", this.m_aForeignElements, CollectionHelper::isNotEmpty).getToString();
    }
}

