/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.xpath;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public class XPathLetVariableResolver
implements XPathVariableResolver {
    private final ThreadLocal<ICommonsMap<QName, Object>> m_aTLVariables = new ThreadLocal<ICommonsMap<QName, Object>>(){

        @Override
        protected ICommonsMap<QName, Object> initialValue() {
            return new CommonsHashMap();
        }
    };
    private final XPathVariableResolver m_aDelegatedResolver;

    public XPathLetVariableResolver(@Nullable XPathVariableResolver xPathVariableResolver) {
        this.m_aDelegatedResolver = xPathVariableResolver;
    }

    public void setVariableValue(@Nonnull QName qName, @Nullable Object object) {
        ValueEnforcer.notNull((Object)qName, (String)"VariableName");
        this.m_aTLVariables.get().put((Object)qName, object);
    }

    public void removeVariable(@Nullable QName qName) {
        if (qName != null) {
            this.m_aTLVariables.get().remove((Object)qName);
        }
    }

    @Override
    public Object resolveVariable(@Nullable QName qName) {
        if (qName != null) {
            Object object = this.m_aTLVariables.get().get((Object)qName);
            if (object != null) {
                return object;
            }
            if (this.m_aDelegatedResolver != null) {
                return this.m_aDelegatedResolver.resolveVariable(qName);
            }
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Variables", this.m_aTLVariables.get()).append("DelegatedResolver", (Object)this.m_aDelegatedResolver).getToString();
    }
}

