/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.schxslt.xslt2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.schxslt.xslt2.SchematronProviderXSLTFromSchXslt_XSLT2;
import com.helger.schematron.schxslt.xslt2.TransformerCustomizerSchXslt_XSLT2;
import com.helger.xml.serialize.write.XMLWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@ThreadSafe
public final class SchematronResourceSchXslt_XSLT2Cache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronResourceSchXslt_XSLT2Cache.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<String, SchematronProviderXSLTFromSchXslt_XSLT2> MAP = new CommonsHashMap();

    private SchematronResourceSchXslt_XSLT2Cache() {
    }

    @Nullable
    public static SchematronProviderXSLTFromSchXslt_XSLT2 createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSchXslt_XSLT2 transformerCustomizerSchXslt_XSLT2) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compiling Schematron instance " + iReadableResource.toString());
        }
        SchematronProviderXSLTFromSchXslt_XSLT2 schematronProviderXSLTFromSchXslt_XSLT2 = new SchematronProviderXSLTFromSchXslt_XSLT2(iReadableResource, transformerCustomizerSchXslt_XSLT2);
        schematronProviderXSLTFromSchXslt_XSLT2.convertSchematronToXSLT();
        if (!schematronProviderXSLTFromSchXslt_XSLT2.isValidSchematron()) {
            LOGGER.warn("The Schematron resource '" + iReadableResource.getResourceID() + "' is invalid!");
            if (LOGGER.isDebugEnabled() && schematronProviderXSLTFromSchXslt_XSLT2.getXSLTDocument() != null) {
                LOGGER.debug("  Created XSLT document:\n" + XMLWriter.getNodeAsString((Node)schematronProviderXSLTFromSchXslt_XSLT2.getXSLTDocument()));
            }
            return null;
        }
        if (schematronProviderXSLTFromSchXslt_XSLT2.getXSLTDocument() == null) {
            throw new IllegalStateException("No XSLT document retrieved from Schematron resource '" + iReadableResource.getResourceID() + "'!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished compiling Schematron instance " + iReadableResource.toString());
        }
        return schematronProviderXSLTFromSchXslt_XSLT2;
    }

    @Nullable
    public static SchematronProviderXSLTFromSchXslt_XSLT2 getSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSchXslt_XSLT2 transformerCustomizerSchXslt_XSLT2) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)transformerCustomizerSchXslt_XSLT2, (String)"TransformerCustomizer");
        if (!iReadableResource.exists()) {
            LOGGER.warn("Schematron resource " + iReadableResource + " does not exist!");
            return null;
        }
        if (!transformerCustomizerSchXslt_XSLT2.canCacheResult()) {
            return SchematronResourceSchXslt_XSLT2Cache.createSchematronXSLTProvider(iReadableResource, transformerCustomizerSchXslt_XSLT2);
        }
        String string = StringHelper.getImploded((char)':', (Object[])new String[]{iReadableResource.getResourceID(), StringHelper.getNotNull((String)transformerCustomizerSchXslt_XSLT2.getPhase()), StringHelper.getNotNull((String)transformerCustomizerSchXslt_XSLT2.getLanguageCode())});
        SchematronProviderXSLTFromSchXslt_XSLT2 schematronProviderXSLTFromSchXslt_XSLT2 = (SchematronProviderXSLTFromSchXslt_XSLT2)RW_LOCK.readLockedGet(() -> (SchematronProviderXSLTFromSchXslt_XSLT2)MAP.get((Object)string));
        if (schematronProviderXSLTFromSchXslt_XSLT2 == null && (schematronProviderXSLTFromSchXslt_XSLT2 = (SchematronProviderXSLTFromSchXslt_XSLT2)RW_LOCK.writeLockedGet(() -> (SchematronProviderXSLTFromSchXslt_XSLT2)MAP.get((Object)string))) == null) {
            SchematronProviderXSLTFromSchXslt_XSLT2 schematronProviderXSLTFromSchXslt_XSLT22 = SchematronResourceSchXslt_XSLT2Cache.createSchematronXSLTProvider(iReadableResource, transformerCustomizerSchXslt_XSLT2);
            if (schematronProviderXSLTFromSchXslt_XSLT22 != null) {
                RW_LOCK.writeLocked(() -> MAP.put((Object)string, (Object)schematronProviderXSLTFromSchXslt_XSLT22));
            }
            schematronProviderXSLTFromSchXslt_XSLT2 = schematronProviderXSLTFromSchXslt_XSLT22;
        }
        return schematronProviderXSLTFromSchXslt_XSLT2;
    }

    public static void clearCache() {
        RW_LOCK.writeLocked(() -> MAP.clear());
    }
}

