/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.naptr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.timing.StopWatch;
import com.helger.dns.naptr.INaptrLookupTimeExceededCallback;
import com.helger.dns.naptr.LoggingNaptrLookupTimeExceededCallback;
import com.helger.dns.resolve.ResolverHelper;
import java.net.InetAddress;
import java.time.Duration;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TextParseException;

@Immutable
public class NaptrLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(NaptrLookup.class);
    private final Name m_aDomainName;
    private final ICommonsList<InetAddress> m_aCustomDNSServers;
    private final int m_nMaxRetries;
    private final Duration m_aTimeout;
    private final ELookupNetworkMode m_eLookupMode;
    private final Duration m_aExecutionDurationWarn;
    private final CallbackList<INaptrLookupTimeExceededCallback> m_aExecutionTimeExceededHandlers;
    private final boolean m_bDebugMode;

    public NaptrLookup(@Nonnull Name name, @Nullable ICommonsList<InetAddress> iCommonsList, @Nonnegative int n, @Nullable Duration duration, @Nonnull ELookupNetworkMode eLookupNetworkMode, @Nullable Duration duration2, @Nullable CallbackList<INaptrLookupTimeExceededCallback> callbackList, boolean bl) {
        ValueEnforcer.notNull((Object)name, (String)"DomainName");
        ValueEnforcer.isGE0((int)n, (String)"MaxRetries");
        ValueEnforcer.notNull((Object)((Object)eLookupNetworkMode), (String)"LookupMode");
        this.m_aDomainName = name;
        this.m_aCustomDNSServers = new CommonsArrayList(iCommonsList);
        this.m_nMaxRetries = n;
        this.m_aTimeout = duration;
        this.m_eLookupMode = eLookupNetworkMode;
        this.m_aExecutionDurationWarn = duration2;
        this.m_aExecutionTimeExceededHandlers = new CallbackList(callbackList);
        this.m_bDebugMode = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ICommonsList<NAPTRRecord> lookup() {
        CommonsArrayList commonsArrayList;
        CommonsArrayList commonsArrayList2;
        int n;
        StopWatch stopWatch;
        Consumer<String> consumer;
        BooleanSupplier booleanSupplier;
        String string;
        block18: {
            int n2;
            string = this.m_aDomainName.toString(true);
            LOGGER.info("Trying to look up NAPTR on '" + string + "'" + (String)(this.m_nMaxRetries > 0 ? " with " + this.m_nMaxRetries + " retries" : "") + " using network mode " + String.valueOf((Object)this.m_eLookupMode));
            BooleanSupplier booleanSupplier2 = this.m_bDebugMode ? () -> ((Logger)LOGGER).isInfoEnabled() : (booleanSupplier = () -> ((Logger)LOGGER).isDebugEnabled());
            consumer = this.m_bDebugMode ? arg_0 -> ((Logger)LOGGER).info(arg_0) : arg_0 -> ((Logger)LOGGER).debug(arg_0);
            stopWatch = StopWatch.createdStarted();
            ExtendedResolver extendedResolver = ResolverHelper.createExtendedResolver(this.m_aCustomDNSServers);
            extendedResolver.setRetries(this.m_nMaxRetries);
            if (this.m_aTimeout != null) {
                extendedResolver.setTimeout(this.m_aTimeout);
            }
            Lookup lookup = new Lookup(this.m_aDomainName, 35);
            lookup.setResolver((Resolver)extendedResolver);
            n = 0;
            boolean bl = true;
            commonsArrayList2 = null;
            if (this.m_eLookupMode.isUDP()) {
                if (booleanSupplier.getAsBoolean()) {
                    consumer.accept("  Trying UDP for NAPTR lookup after " + n + " unsuccessful lopkups");
                }
                n2 = this.m_nMaxRetries;
                do {
                    commonsArrayList2 = lookup.run();
                    if (booleanSupplier.getAsBoolean()) {
                        consumer.accept("    Result of UDP lookup " + n + ": " + lookup.getErrorString());
                    }
                    ++n;
                } while (lookup.getResult() == 2 && --n2 >= 0);
                if (lookup.getResult() != 2) {
                    bl = false;
                }
            }
            if (bl && this.m_eLookupMode.isTCP()) {
                if (booleanSupplier.getAsBoolean()) {
                    consumer.accept("  Trying TCP for NAPTR lookup after " + n + " unsuccessful lopkups");
                }
                extendedResolver.setTCP(true);
                n2 = this.m_nMaxRetries;
                do {
                    commonsArrayList2 = lookup.run();
                    if (booleanSupplier.getAsBoolean()) {
                        consumer.accept("    Result of TCP lookup " + n + ": " + lookup.getErrorString());
                    }
                    ++n;
                } while (lookup.getResult() == 2 && --n2 >= 0);
            }
            if (lookup.getResult() == 0) break block18;
            LOGGER.warn("Error looking up '" + string + "': " + lookup.getErrorString());
            CommonsArrayList commonsArrayList3 = new CommonsArrayList();
            stopWatch.stop();
            Duration duration = stopWatch.getDuration();
            if (this.m_aExecutionDurationWarn != null && duration.compareTo(this.m_aExecutionDurationWarn) > 0) {
                String string2 = "Looking up NAPTR record of '" + string + "'" + (String)(this.m_nMaxRetries > 0 ? " with " + this.m_nMaxRetries + " retries" : "");
                this.m_aExecutionTimeExceededHandlers.forEach(iNaptrLookupTimeExceededCallback -> iNaptrLookupTimeExceededCallback.onLookupTimeExceeded(string2, duration, this.m_aExecutionDurationWarn));
            }
            return commonsArrayList3;
        }
        try {
            CommonsArrayList commonsArrayList4 = new CommonsArrayList();
            for (Record record : commonsArrayList2) {
                commonsArrayList4.add((Object)((NAPTRRecord)record));
            }
            if (booleanSupplier.getAsBoolean()) {
                consumer.accept("  Returning " + commonsArrayList4.size() + " NAPTR record(s) for '" + string + "' after " + n + " lookups");
            }
            commonsArrayList = commonsArrayList4;
        }
        catch (Throwable throwable) {
            stopWatch.stop();
            Duration duration = stopWatch.getDuration();
            if (this.m_aExecutionDurationWarn != null && duration.compareTo(this.m_aExecutionDurationWarn) > 0) {
                String string3 = "Looking up NAPTR record of '" + string + "'" + (String)(this.m_nMaxRetries > 0 ? " with " + this.m_nMaxRetries + " retries" : "");
                this.m_aExecutionTimeExceededHandlers.forEach(iNaptrLookupTimeExceededCallback -> iNaptrLookupTimeExceededCallback.onLookupTimeExceeded(string2, duration, this.m_aExecutionDurationWarn));
            }
            throw throwable;
        }
        stopWatch.stop();
        Duration duration = stopWatch.getDuration();
        if (this.m_aExecutionDurationWarn != null && duration.compareTo(this.m_aExecutionDurationWarn) > 0) {
            String string4 = "Looking up NAPTR record of '" + string + "'" + (String)(this.m_nMaxRetries > 0 ? " with " + this.m_nMaxRetries + " retries" : "");
            this.m_aExecutionTimeExceededHandlers.forEach(iNaptrLookupTimeExceededCallback -> iNaptrLookupTimeExceededCallback.onLookupTimeExceeded(string2, duration, this.m_aExecutionDurationWarn));
        }
        return commonsArrayList;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static enum ELookupNetworkMode {
        UDP_TCP(true, true),
        UDP(true, false),
        TCP(false, true);

        private final boolean m_bUDP;
        private final boolean m_bTCP;

        private ELookupNetworkMode(boolean bl, boolean bl2) {
            this.m_bUDP = bl;
            this.m_bTCP = bl2;
        }

        public boolean isUDP() {
            return this.m_bUDP;
        }

        public boolean isTCP() {
            return this.m_bTCP;
        }
    }

    @NotThreadSafe
    public static class Builder
    implements IBuilder<NaptrLookup> {
        public static final int DEFAULT_MAX_RETRIES = 1;
        public static final Duration DEFAULT_EXECUTION_DURATION_WARN = Duration.ofSeconds(1L);
        public static final ELookupNetworkMode DEFAULT_LOOKUP_MODE = ELookupNetworkMode.UDP_TCP;
        private Name m_aDomainName;
        private final ICommonsList<InetAddress> m_aCustomDNSServers = new CommonsArrayList();
        private int m_nMaxRetries = 1;
        private Duration m_aTimeout;
        private Duration m_aExecutionDurationWarn = DEFAULT_EXECUTION_DURATION_WARN;
        private final CallbackList<INaptrLookupTimeExceededCallback> m_aExecutionTimeExceededHandlers = new CallbackList();
        private ELookupNetworkMode m_eLookupMode = DEFAULT_LOOKUP_MODE;
        private boolean m_bDebugMode = false;

        public Builder() {
            this.m_aExecutionTimeExceededHandlers.add((ICallback)new LoggingNaptrLookupTimeExceededCallback(false));
        }

        @Nullable
        public final Name domainName() {
            return this.m_aDomainName;
        }

        @Nullable
        public final String domainNameString() {
            return this.m_aDomainName == null ? null : this.m_aDomainName.toString(false);
        }

        @Nonnull
        public final Builder domainName(@Nullable String string) throws TextParseException {
            return this.domainName(Name.fromString((String)string));
        }

        @Nonnull
        public final Builder domainName(@Nullable Name name) {
            this.m_aDomainName = name;
            return this;
        }

        @Nonnull
        public final Builder customDNSServer(@Nullable InetAddress inetAddress) {
            if (inetAddress == null) {
                this.m_aCustomDNSServers.clear();
            } else {
                this.m_aCustomDNSServers.set((Object)inetAddress);
            }
            return this;
        }

        @Nonnull
        public final Builder customDNSServers(InetAddress ... inetAddressArray) {
            if (inetAddressArray == null) {
                this.m_aCustomDNSServers.clear();
            } else {
                this.m_aCustomDNSServers.setAll((Object[])inetAddressArray);
            }
            return this;
        }

        @Nonnull
        public final Builder customDNSServers(@Nullable Iterable<? extends InetAddress> iterable) {
            if (iterable == null) {
                this.m_aCustomDNSServers.clear();
            } else {
                this.m_aCustomDNSServers.setAll(iterable);
            }
            return this;
        }

        @Nonnull
        public final Builder addCustomDNSServer(@Nullable InetAddress inetAddress) {
            if (inetAddress != null) {
                this.m_aCustomDNSServers.add((Object)inetAddress);
            }
            return this;
        }

        @Nonnull
        public final Builder addCustomDNSServers(InetAddress ... inetAddressArray) {
            if (inetAddressArray != null) {
                this.m_aCustomDNSServers.addAll((Object[])inetAddressArray);
            }
            return this;
        }

        @Nonnull
        public final Builder addCustomDNSServers(@Nullable Iterable<? extends InetAddress> iterable) {
            if (iterable != null) {
                this.m_aCustomDNSServers.addAll(iterable);
            }
            return this;
        }

        @Nonnull
        public final Builder maxRetries(int n) {
            this.m_nMaxRetries = n;
            return this;
        }

        @Nonnull
        public final Builder noRetries() {
            return this.maxRetries(0);
        }

        @Nonnull
        public final Builder timeoutMS(long l) {
            return this.timeout(l < 0L ? null : Duration.ofMillis(l));
        }

        @Nonnull
        public final Builder timeout(@Nullable Duration duration) {
            this.m_aTimeout = duration;
            return this;
        }

        @Nonnull
        public final Builder lookupMode(@Nullable ELookupNetworkMode eLookupNetworkMode) {
            this.m_eLookupMode = eLookupNetworkMode;
            return this;
        }

        @Nonnull
        public final Builder executionDurationWarnMS(long l) {
            return this.executionDurationWarn(l < 0L ? null : Duration.ofMillis(l));
        }

        @Nonnull
        public final Builder executionDurationWarn(@Nullable Duration duration) {
            this.m_aExecutionDurationWarn = duration;
            return this;
        }

        @Nonnull
        public final Builder addExecutionTimeExceededHandler(@Nullable INaptrLookupTimeExceededCallback iNaptrLookupTimeExceededCallback) {
            if (iNaptrLookupTimeExceededCallback != null) {
                this.m_aExecutionTimeExceededHandlers.add((ICallback)iNaptrLookupTimeExceededCallback);
            }
            return this;
        }

        @Nonnull
        public final Builder debugMode(boolean bl) {
            this.m_bDebugMode = bl;
            return this;
        }

        @Nonnull
        public NaptrLookup build() {
            if (this.m_aDomainName == null) {
                throw new IllegalStateException("The domain name is required");
            }
            if (this.m_nMaxRetries < 0) {
                throw new IllegalStateException("The maximum number of retries must be >= 0");
            }
            if (this.m_eLookupMode == null) {
                throw new IllegalStateException("The network lookup mode must be provided");
            }
            return new NaptrLookup(this.m_aDomainName, this.m_aCustomDNSServers, this.m_nMaxRetries, this.m_aTimeout, this.m_eLookupMode, this.m_aExecutionDurationWarn, this.m_aExecutionTimeExceededHandlers, this.m_bDebugMode);
        }

        @Nonnull
        public ICommonsList<NAPTRRecord> lookup() {
            return this.build().lookup();
        }
    }
}

