/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.naptr;

import com.helger.commons.string.ToStringGenerator;
import com.helger.dns.naptr.INaptrLookupTimeExceededCallback;
import java.time.Duration;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingNaptrLookupTimeExceededCallback
implements INaptrLookupTimeExceededCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingNaptrLookupTimeExceededCallback.class);
    private boolean m_bEmitStackTrace;

    public LoggingNaptrLookupTimeExceededCallback(boolean bl) {
        this.setEmitStackTrace(bl);
    }

    public final boolean isEmitStackTrace() {
        return this.m_bEmitStackTrace;
    }

    @Nonnull
    public final LoggingNaptrLookupTimeExceededCallback setEmitStackTrace(boolean bl) {
        this.m_bEmitStackTrace = bl;
        return this;
    }

    @Override
    public void onLookupTimeExceeded(@Nonnull String string, @Nonnull Duration duration, @Nonnull Duration duration2) {
        LOGGER.warn(string + " took " + duration.toMillis() + "ms (limit is " + duration2.toMillis() + " ms)", (Throwable)(this.m_bEmitStackTrace ? new Exception() : null));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("EmitStackTrace", this.m_bEmitStackTrace).getToString();
    }
}

