/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.naptr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.dns.naptr.NaptrLookup;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

@Immutable
public class NaptrResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(NaptrResolver.class);
    private final String m_sDomainName;
    private final ICommonsList<NAPTRRecord> m_aNaptrRecords;
    private final Predicate<? super String> m_aServiceNameMatcher;

    public NaptrResolver(@Nonnull String string, @Nonnull ICommonsList<NAPTRRecord> iCommonsList, @Nonnull Predicate<? super String> predicate) {
        ValueEnforcer.notNull((Object)string, (String)"DomainName");
        ValueEnforcer.notNull(iCommonsList, (String)"NAPTRRecords");
        ValueEnforcer.notNull(predicate, (String)"ServiceNameMatcher");
        this.m_sDomainName = string;
        this.m_aNaptrRecords = iCommonsList;
        this.m_aServiceNameMatcher = predicate;
    }

    @Nonnull
    public static Predicate<String> getDefaultServiceNameMatcher(@Nonnull String string) {
        return string::equalsIgnoreCase;
    }

    @Nullable
    static String getAppliedNAPTRRegEx(@Nonnull String string, @Nonnull String string2) {
        int n;
        char c = string.charAt(0);
        int n2 = string.indexOf(c, 1);
        if (n2 < 0) {
            LOGGER.warn("NAPTR regex '" + string + "' - failed to find second separator");
            return null;
        }
        Object object = string.substring(1, n2);
        if (!((String)object).startsWith("^")) {
            object = "^" + (String)object;
        }
        if (!((String)object).endsWith("$")) {
            object = (String)object + "$";
        }
        if ((n = string.indexOf(c, n2 + 1)) < 0) {
            LOGGER.warn("NAPTR regex '" + string + "' - failed to find third separator");
            return null;
        }
        String string3 = string.substring(n2 + 1, n);
        String string4 = string.substring(n + 1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("NAPTR regex: '" + (String)object + "' - '" + string3 + "' - '" + string4 + "'");
        }
        int n3 = "i".equalsIgnoreCase(string4) ? 2 : 0;
        String string5 = RegExHelper.stringReplacePattern((String)object, (int)n3, (String)string2, (String)string3);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  NAPTR replacement: '" + string2 + "' -> '" + string5 + "'");
        }
        return string5;
    }

    @Nullable
    public String resolveUNAPTR() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (NAPTRRecord nAPTRRecord3 : this.m_aNaptrRecords) {
            if (!"U".equalsIgnoreCase(nAPTRRecord3.getFlags()) || !this.m_aServiceNameMatcher.test(nAPTRRecord3.getService())) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found a matching U-NAPTR record: " + String.valueOf(nAPTRRecord3));
            }
            commonsArrayList.add((Object)nAPTRRecord3);
        }
        if (commonsArrayList.isEmpty()) {
            LOGGER.warn("No matching DNS U-NAPTR records returned for '" + this.m_sDomainName + "'");
            return null;
        }
        commonsArrayList.sort((nAPTRRecord, nAPTRRecord2) -> {
            int n = CompareHelper.compare((int)nAPTRRecord.getOrder(), (int)nAPTRRecord2.getOrder());
            if (n == 0) {
                n = CompareHelper.compare((int)nAPTRRecord.getPreference(), (int)nAPTRRecord2.getPreference());
            }
            return n;
        });
        for (NAPTRRecord nAPTRRecord3 : commonsArrayList) {
            String string;
            String string2 = nAPTRRecord3.getRegexp();
            if (StringHelper.getLength((CharSequence)string2) <= 3 || (string = NaptrResolver.getAppliedNAPTRRegEx(string2, this.m_sDomainName)) == null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using '" + string + "' for original domain name '" + this.m_sDomainName + "'");
            }
            return string;
        }
        LOGGER.warn("None of the matching DNS NAPTR records for '" + this.m_sDomainName + "' has a valid regular expression. Details: " + String.valueOf(commonsArrayList));
        return null;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static class Builder
    implements IBuilder<NaptrResolver> {
        private String m_sDomainName;
        private final ICommonsList<NAPTRRecord> m_aNaptrRecords = new CommonsArrayList();
        private boolean m_bNaptrLookupProvided = false;
        private Predicate<? super String> m_aServiceNameMatcher;

        @Nonnull
        public final Builder domainName(@Nullable NaptrLookup.Builder builder) {
            return this.domainName(builder == null ? null : builder.domainName());
        }

        @Nonnull
        public final Builder domainName(@Nullable Name name) {
            return this.domainName(name == null ? null : name.toString(false));
        }

        @Nonnull
        public final Builder domainName(@Nullable String string) {
            this.m_sDomainName = string;
            return this;
        }

        @Nonnull
        public final Builder naptrRecords(@Nullable NaptrLookup.Builder builder) {
            return this.naptrRecords(builder == null ? null : builder.build());
        }

        @Nonnull
        public final Builder naptrRecords(@Nullable NaptrLookup naptrLookup) {
            if (naptrLookup != null) {
                this.m_bNaptrLookupProvided = true;
            }
            return this.naptrRecords((Iterable<? extends NAPTRRecord>)(naptrLookup == null ? null : naptrLookup.lookup()));
        }

        @Nonnull
        public final Builder naptrRecord(@Nullable NAPTRRecord nAPTRRecord) {
            if (nAPTRRecord == null) {
                this.m_aNaptrRecords.clear();
            } else {
                this.m_aNaptrRecords.set((Object)nAPTRRecord);
            }
            return this;
        }

        @Nonnull
        public final Builder naptrRecords(NAPTRRecord ... nAPTRRecordArray) {
            if (nAPTRRecordArray == null) {
                this.m_aNaptrRecords.clear();
            } else {
                this.m_aNaptrRecords.setAll((Object[])nAPTRRecordArray);
            }
            return this;
        }

        @Nonnull
        public final Builder naptrRecords(@Nullable Iterable<? extends NAPTRRecord> iterable) {
            if (iterable == null) {
                this.m_aNaptrRecords.clear();
            } else {
                this.m_aNaptrRecords.setAll(iterable);
            }
            return this;
        }

        @Nonnull
        public final Builder addNaptrRecord(@Nullable NAPTRRecord nAPTRRecord) {
            if (nAPTRRecord != null) {
                this.m_aNaptrRecords.add((Object)nAPTRRecord);
            }
            return this;
        }

        @Nonnull
        public final Builder addNaptrRecords(NAPTRRecord ... nAPTRRecordArray) {
            if (nAPTRRecordArray != null) {
                this.m_aNaptrRecords.addAll((Object[])nAPTRRecordArray);
            }
            return this;
        }

        @Nonnull
        public final Builder addNaptrRecords(@Nullable Iterable<? extends NAPTRRecord> iterable) {
            if (iterable != null) {
                this.m_aNaptrRecords.addAll(iterable);
            }
            return this;
        }

        @Nonnull
        public final Builder serviceName(@Nullable String string) {
            return this.serviceName(string == null ? null : NaptrResolver.getDefaultServiceNameMatcher(string));
        }

        @Nonnull
        public final Builder serviceName(@Nullable Predicate<? super String> predicate) {
            this.m_aServiceNameMatcher = predicate;
            return this;
        }

        @Nonnull
        public NaptrResolver build() {
            if (StringHelper.hasNoText((String)this.m_sDomainName)) {
                throw new IllegalStateException("Domain name is required");
            }
            if (this.m_aNaptrRecords.isEmpty()) {
                LOGGER.warn("No NAPTR records are provided." + (this.m_bNaptrLookupProvided ? "" : " Using the default lookup."));
                if (!this.m_bNaptrLookupProvided) {
                    try {
                        this.naptrRecords(NaptrLookup.builder().domainName(this.m_sDomainName));
                    }
                    catch (TextParseException textParseException) {
                        LOGGER.error("Creepy domain found", (Throwable)textParseException);
                    }
                }
            }
            if (this.m_aServiceNameMatcher == null) {
                throw new IllegalStateException("The service name predicate is required");
            }
            return new NaptrResolver(this.m_sDomainName, this.m_aNaptrRecords, this.m_aServiceNameMatcher);
        }
    }
}

