/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.httpclient.HttpClientHelper;
import com.helger.httpclient.response.ResponseHandlerHttpEntity;
import com.helger.json.IJson;
import com.helger.json.serialize.JsonReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponseHandlerJson<T extends IJson, IMPLTYPE extends AbstractResponseHandlerJson<T, IMPLTYPE>>
implements HttpClientResponseHandler<T>,
IGenericImplTrait<IMPLTYPE> {
    public static final boolean DEFAULT_DEBUG_MODE = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResponseHandlerJson.class);
    private final Function<IJson, T> m_aMapper;
    private boolean m_bDebugMode = false;
    private Charset m_aFallbackCharset = HttpClientHelper.DEF_CONTENT_CHARSET;

    protected AbstractResponseHandlerJson(@Nonnull Function<IJson, T> function) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        this.m_aMapper = function;
    }

    public final boolean isDebugMode() {
        return this.m_bDebugMode;
    }

    @Nonnull
    public final IMPLTYPE setDebugMode(boolean bl) {
        this.m_bDebugMode = bl;
        return (IMPLTYPE)((AbstractResponseHandlerJson)this.thisAsT());
    }

    @Nonnull
    public final Charset getFallbackCharset() {
        return this.m_aFallbackCharset;
    }

    @Nonnull
    public final IMPLTYPE setFallbackCharset(@Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
        this.m_aFallbackCharset = charset;
        return (IMPLTYPE)((AbstractResponseHandlerJson)this.thisAsT());
    }

    @Nullable
    public T handleResponse(@Nonnull ClassicHttpResponse classicHttpResponse) throws IOException {
        HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(classicHttpResponse);
        if (httpEntity == null) {
            throw new ClientProtocolException("Response contains no content");
        }
        ContentType contentType = HttpClientHelper.getContentTypeOrDefault(httpEntity);
        Charset charset = HttpClientHelper.getCharset(contentType, this.m_aFallbackCharset);
        if (this.m_bDebugMode) {
            String string = StringHelper.trim((String)HttpClientHelper.entityToString(httpEntity, charset));
            LOGGER.info("Got JSON in [" + String.valueOf(charset) + "]: <" + string + ">");
            IJson iJson = JsonReader.readFromString((String)string);
            if (iJson == null) {
                throw new IllegalArgumentException("Failed to parse as JSON: " + string);
            }
            return (T)((IJson)this.m_aMapper.apply(iJson));
        }
        IJson iJson = JsonReader.builder().source(httpEntity.getContent(), charset).read();
        return (T)((IJson)this.m_aMapper.apply(iJson));
    }
}

