/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.security;

import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import javax.net.ssl.SSLParameters;
import org.apache.hc.core5.ssl.PrivateKeyDetails;
import org.apache.hc.core5.ssl.PrivateKeyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyStrategyFromAliasCaseSensitive
implements PrivateKeyStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivateKeyStrategyFromAliasCaseSensitive.class);
    private final String m_sExpectedAlias;

    public PrivateKeyStrategyFromAliasCaseSensitive(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"ExpectedAlias");
        this.m_sExpectedAlias = string;
    }

    @Nonnull
    public final String getExpectedAlias() {
        return this.m_sExpectedAlias;
    }

    @Nullable
    public String chooseAlias(@Nonnull Map<String, PrivateKeyDetails> map, @Nullable SSLParameters sSLParameters) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("chooseAlias(" + String.valueOf(map) + ", " + String.valueOf(sSLParameters) + ")");
        }
        for (String string : map.keySet()) {
            if (!string.equals(this.m_sExpectedAlias)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("  Chose alias '" + string + "'");
            }
            return string;
        }
        LOGGER.warn("Found no certificate alias matching '" + this.m_sExpectedAlias + "' in the provided aliases " + String.valueOf(map.keySet()));
        return null;
    }
}

