/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mail.datasource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.ToStringGenerator;
import com.helger.mail.datasource.IExtendedDataSource;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InputStreamDataSource
implements IExtendedDataSource,
IHasInputStream {
    public static final boolean DEFAULT_READ_MULTIPLE = false;
    private final InputStream m_aIS;
    private int m_nISAcquired = 0;
    private final String m_sName;
    private final String m_sContentType;
    private final boolean m_bReadMultiple;

    public InputStreamDataSource(@Nonnull InputStream inputStream, @Nonnull String string) {
        this(inputStream, string, (String)null, false);
    }

    public InputStreamDataSource(@Nonnull InputStream inputStream, @Nonnull String string, boolean bl) {
        this(inputStream, string, (String)null, bl);
    }

    public InputStreamDataSource(@Nonnull InputStream inputStream, @Nonnull String string, @Nullable IMimeType iMimeType, boolean bl) {
        this(inputStream, string, iMimeType == null ? null : iMimeType.getAsString(), bl);
    }

    public InputStreamDataSource(@Nonnull InputStream inputStream, @Nonnull String string, @Nullable IMimeType iMimeType) {
        this(inputStream, string, iMimeType == null ? null : iMimeType.getAsString(), false);
    }

    public InputStreamDataSource(@Nonnull InputStream inputStream, @Nonnull String string, @Nullable String string2) {
        this(inputStream, string, string2, false);
    }

    public InputStreamDataSource(@Nonnull InputStream inputStream, @Nonnull String string, @Nullable String string2, boolean bl) {
        this.m_aIS = (InputStream)ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        this.m_sName = (String)ValueEnforcer.notNull((Object)string, (String)"Name");
        this.m_sContentType = string2 != null ? string2 : DEFAULT_CONTENT_TYPE.getAsString();
        this.m_bReadMultiple = bl;
    }

    public final boolean isReadMultiple() {
        return this.m_bReadMultiple;
    }

    @Nonnegative
    public final int getISAcquisitionCount() {
        return this.m_nISAcquired;
    }

    @Nonnull
    public InputStream getInputStream() {
        ++this.m_nISAcquired;
        if (!this.m_bReadMultiple && this.m_nISAcquired > 1) {
            throw new IllegalStateException("The input stream was already acquired " + (this.m_nISAcquired - 1) + " times!");
        }
        return this.m_aIS;
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("Read-only!");
    }

    @Nonnull
    public String getContentType() {
        return this.m_sContentType;
    }

    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("IS", (Object)this.m_aIS).append("ISAcquired", this.m_nISAcquired).append("Name", (Object)this.m_sName).append("ContentType", (Object)this.m_sContentType).append("ReadMultiple", this.m_bReadMultiple).getToString();
    }
}

