/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.logging;

import com.helger.collection.commons.ICommonsMap;
import com.helger.http.header.HttpHeaderMap;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

final class LoggingRequest {
    private String m_sSender;
    private String m_sMethod;
    private String m_sPath;
    private ICommonsMap<String, String> m_aParams;
    private HttpHeaderMap m_aHeaders;
    private String m_sBody;

    LoggingRequest() {
    }

    @Nullable
    public String getSender() {
        return this.m_sSender;
    }

    public void setSender(@Nullable String string) {
        this.m_sSender = string;
    }

    @Nullable
    public String getMethod() {
        return this.m_sMethod;
    }

    public void setMethod(@Nullable String string) {
        this.m_sMethod = string;
    }

    @Nullable
    public String getPath() {
        return this.m_sPath;
    }

    public void setPath(@Nullable String string) {
        this.m_sPath = string;
    }

    @Nullable
    public ICommonsMap<String, String> getParams() {
        return this.m_aParams;
    }

    public void setParams(@Nullable ICommonsMap<String, String> iCommonsMap) {
        this.m_aParams = iCommonsMap;
    }

    @Nullable
    public HttpHeaderMap getHeaders() {
        return this.m_aHeaders;
    }

    public void setHeaders(@Nullable HttpHeaderMap httpHeaderMap) {
        this.m_aHeaders = httpHeaderMap;
    }

    @Nullable
    public String getBody() {
        return this.m_sBody;
    }

    public void setBody(@Nullable String string) {
        this.m_sBody = string;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.m_sSender != null) {
            jsonObject.add((Object)"sender", (Object)this.m_sSender);
        }
        if (this.m_sMethod != null) {
            jsonObject.add((Object)"method", (Object)this.m_sMethod);
        }
        if (this.m_sPath != null) {
            jsonObject.add((Object)"path", (Object)this.m_sPath);
        }
        if (this.m_aParams != null) {
            jsonObject.add("params", (IJson)new JsonObject().addAllAny(this.m_aParams));
        }
        if (this.m_aHeaders != null) {
            JsonObject jsonObject2 = new JsonObject();
            this.m_aHeaders.forEachSingleHeader((arg_0, arg_1) -> ((IJsonObject)jsonObject2).add(arg_0, arg_1), true);
            jsonObject.add("headers", (IJson)jsonObject2);
        }
        if (this.m_sBody != null) {
            jsonObject.add((Object)"body", (Object)this.m_sBody);
        }
        return jsonObject;
    }
}

