/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.enumeration.EnumerationHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.Enumeration;
import java.util.Map;

@NotThreadSafe
public class MockServletConfig
implements ServletConfig {
    private final ServletContext m_aSC;
    private final String m_sServletName;
    private final ICommonsOrderedMap<String, String> m_aServletInitParams = new CommonsLinkedHashMap();

    public MockServletConfig(@Nonnull ServletContext servletContext, @Nonnull @Nonempty String string) {
        this(servletContext, string, null);
    }

    public MockServletConfig(@Nonnull ServletContext servletContext, @Nonnull @Nonempty String string, @Nullable Map<String, String> map) {
        this.m_aSC = (ServletContext)ValueEnforcer.notNull((Object)servletContext, (String)"ServletContext");
        this.m_sServletName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ServletName");
        if (map != null) {
            this.m_aServletInitParams.putAll(map);
        }
    }

    @Nonnull
    @Nonempty
    public String getServletName() {
        return this.m_sServletName;
    }

    @Nonnull
    public ServletContext getServletContext() {
        return this.m_aSC;
    }

    @Nullable
    public String getInitParameter(@Nullable String string) {
        return (String)this.m_aServletInitParams.get((Object)string);
    }

    @Nonnull
    public Enumeration<String> getInitParameterNames() {
        return EnumerationHelper.getEnumeration((Iterable)this.m_aServletInitParams.keySet());
    }

    public void addInitParameter(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aServletInitParams.put((Object)string, (Object)string2);
    }

    @Nonnull
    public EChange removeInitParameter(@Nullable String string) {
        return EChange.valueOf((this.m_aServletInitParams.remove((Object)string) != null ? 1 : 0) != 0);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllInitParameters() {
        return this.m_aServletInitParams.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("servletContext", (Object)this.m_aSC).append("servletName", (Object)this.m_sServletName).append("servletInitParams", this.m_aServletInitParams).getToString();
    }
}

