/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.http.EHttpReferrerPolicy;
import com.helger.http.cache.CacheControlBuilder;
import com.helger.http.header.HttpHeaderMap;
import com.helger.servlet.response.EXFrameOptionType;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.Cookie;

@ThreadSafe
public final class UnifiedResponseDefaultSettings {
    public static final boolean DEFAULT_HTTP_HEADER_VALUES_UNIFIED = true;
    public static final boolean DEFAULT_HTTP_HEADER_VALUES_QUOTE_IF_NECESSARY = false;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final HttpHeaderMap RESPONSE_HEADER_MAP = new HttpHeaderMap();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsOrderedMap<String, Cookie> COOKIES = new CommonsLinkedHashMap();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bHttpHeaderValuesUnified = true;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bHttpHeaderValuesQuoteIfNecessary = false;

    private UnifiedResponseDefaultSettings() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HttpHeaderMap getResponseHeaderMap() {
        return (HttpHeaderMap)RW_LOCK.readLockedGet(() -> ((HttpHeaderMap)RESPONSE_HEADER_MAP).getClone());
    }

    public static void setAllowMimeSniffing(boolean bl) {
        if (bl) {
            UnifiedResponseDefaultSettings.removeResponseHeaders("X-Content-Type-Options");
        } else {
            UnifiedResponseDefaultSettings.setResponseHeader("X-Content-Type-Options", "nosniff");
        }
    }

    public static void setStrictTransportSecurity(@Nonnegative int n, boolean bl) {
        UnifiedResponseDefaultSettings.setResponseHeader("Strict-Transport-Security", new CacheControlBuilder().setMaxAgeSeconds((long)n).getAsHTTPHeaderValue() + (bl ? ";includeSubDomains" : ""));
    }

    public static void removeStrictTransportSecurity() {
        UnifiedResponseDefaultSettings.removeResponseHeaders("Strict-Transport-Security");
    }

    public static void setXFrameOptions(@Nullable EXFrameOptionType eXFrameOptionType, @Nullable ISimpleURL iSimpleURL) {
        if (eXFrameOptionType != null && eXFrameOptionType.isURLRequired()) {
            ValueEnforcer.notNull((Object)iSimpleURL, (String)"Domain");
        }
        if (eXFrameOptionType == null) {
            UnifiedResponseDefaultSettings.removeResponseHeaders("X-Frame-Options");
        } else {
            String string = eXFrameOptionType.isURLRequired() ? eXFrameOptionType.getID() + " " + iSimpleURL.getAsString() : eXFrameOptionType.getID();
            UnifiedResponseDefaultSettings.setResponseHeader("X-Frame-Options", string);
        }
    }

    public static void setReferrerPolicy(@Nullable EHttpReferrerPolicy eHttpReferrerPolicy) {
        if (eHttpReferrerPolicy == null || eHttpReferrerPolicy == EHttpReferrerPolicy.NONE) {
            UnifiedResponseDefaultSettings.removeResponseHeaders("Referrer-Policy");
        } else {
            UnifiedResponseDefaultSettings.setResponseHeader("Referrer-Policy", eHttpReferrerPolicy.getValue());
        }
    }

    public static void setResponseHeader(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        RW_LOCK.writeLocked(() -> RESPONSE_HEADER_MAP.setHeader(string, string2));
    }

    public static void addResponseHeader(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        RW_LOCK.writeLocked(() -> RESPONSE_HEADER_MAP.addHeader(string, string2));
    }

    @Nonnull
    public static EChange removeResponseHeaders(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        return (EChange)RW_LOCK.writeLockedGet(() -> RESPONSE_HEADER_MAP.removeHeaders(string));
    }

    @Nonnull
    public static EChange removeAllResponseHeaders() {
        return (EChange)RW_LOCK.writeLockedGet(() -> ((HttpHeaderMap)RESPONSE_HEADER_MAP).removeAll());
    }

    public static boolean hasCookies() {
        return RW_LOCK.readLockedBoolean(() -> COOKIES.isNotEmpty());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, Cookie> getAllCookies() {
        return (ICommonsOrderedMap)RW_LOCK.readLockedGet(() -> COOKIES.getClone());
    }

    public static void addCookie(@Nonnull Cookie cookie) {
        ValueEnforcer.notNull((Object)cookie, (String)"Cookie");
        String string = cookie.getName();
        RW_LOCK.writeLockedGet(() -> (Cookie)COOKIES.put((Object)string, (Object)cookie));
    }

    @Nonnull
    public static EChange removeCookie(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        return (EChange)RW_LOCK.writeLockedGet(() -> COOKIES.removeObject((Object)string));
    }

    @Nonnull
    public static EChange removeAllCookies() {
        return (EChange)RW_LOCK.writeLockedGet(() -> COOKIES.removeAll());
    }

    public static boolean isHttpHeaderValuesUnified() {
        return RW_LOCK.readLockedBoolean(() -> s_bHttpHeaderValuesUnified);
    }

    public static void setHttpHeaderValuesUnified(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bHttpHeaderValuesUnified = bl;
        });
    }

    public static boolean isHttpHeaderValuesQuoteIfNecessary() {
        return RW_LOCK.readLockedBoolean(() -> s_bHttpHeaderValuesQuoteIfNecessary);
    }

    public static void setHttpHeaderValuesQuoteIfNecessary(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bHttpHeaderValuesQuoteIfNecessary = bl;
        });
    }

    static {
        UnifiedResponseDefaultSettings.setAllowMimeSniffing(false);
        UnifiedResponseDefaultSettings.setStrictTransportSecurity(3600, true);
        UnifiedResponseDefaultSettings.setXFrameOptions(EXFrameOptionType.DEFAULT, null);
        UnifiedResponseDefaultSettings.setReferrerPolicy(EHttpReferrerPolicy.NONE);
    }
}

