/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.handler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.attr.IAttributeContainerAny;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.EHttpVersion;
import com.helger.servlet.async.AsyncServletRunnerDefault;
import com.helger.servlet.async.ExtAsyncContext;
import com.helger.servlet.async.IAsyncServletRunner;
import com.helger.servlet.async.ServletAsyncSpec;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.mgr.WebScoped;
import com.helger.xservlet.handler.IXServletHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XServletAsyncHandler
implements IXServletHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XServletAsyncHandler.class);
    private static IAsyncServletRunner s_aAsyncServletRunner = new AsyncServletRunnerDefault();
    private final ServletAsyncSpec m_aAsyncSpec;
    private final IXServletHandler m_aNestedHandler;

    public static void setAsyncServletRunner(@Nonnull IAsyncServletRunner iAsyncServletRunner) {
        ValueEnforcer.notNull((Object)iAsyncServletRunner, (String)"AsyncServletRunner");
        s_aAsyncServletRunner = iAsyncServletRunner;
    }

    @Nonnull
    public static IAsyncServletRunner getAsyncServletRunner() {
        return s_aAsyncServletRunner;
    }

    public XServletAsyncHandler(@Nonnull ServletAsyncSpec servletAsyncSpec, @Nonnull IXServletHandler iXServletHandler) {
        this.m_aAsyncSpec = (ServletAsyncSpec)ValueEnforcer.notNull((Object)servletAsyncSpec, (String)"AsyncSpec");
        this.m_aNestedHandler = (IXServletHandler)ValueEnforcer.notNull((Object)iXServletHandler, (String)"NestedHandler");
    }

    @Override
    public void onServletInit(@Nonnull ICommonsMap<String, String> iCommonsMap) throws ServletException {
        this.m_aNestedHandler.onServletInit(iCommonsMap);
    }

    @Override
    public void onServletDestroy() {
        this.m_aNestedHandler.onServletDestroy();
    }

    private void _handleAsync(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) {
        ExtAsyncContext extAsyncContext = ExtAsyncContext.create((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (EHttpVersion)eHttpVersion, (EHttpMethod)eHttpMethod, (ServletAsyncSpec)this.m_aAsyncSpec);
        IAttributeContainerAny iAttributeContainerAny = iRequestWebScope.attrs().getClone();
        IAttributeContainerAny iAttributeContainerAny2 = iRequestWebScope.params().getClone();
        s_aAsyncServletRunner.runAsync(httpServletRequest, httpServletResponse, extAsyncContext, () -> {
            try (WebScoped webScoped = new WebScoped(httpServletRequest, httpServletResponse);){
                webScoped.getRequestScope().attrs().putAllIn((Map)iAttributeContainerAny);
                webScoped.getRequestScope().params().putAllIn((Map)iAttributeContainerAny2);
                this.m_aNestedHandler.onRequest(extAsyncContext.getRequest(), extAsyncContext.getResponse(), extAsyncContext.getHTTPVersion(), extAsyncContext.getHTTPMethod(), webScoped.getRequestScope());
            }
            catch (Exception exception) {
                LOGGER.error("Error processing async request " + String.valueOf(extAsyncContext.getRequest()), (Throwable)exception);
                try {
                    String string = "Internal error processing your request. Please try again later. Technical details: " + exception.getClass().getName() + ":" + exception.getMessage();
                    extAsyncContext.getResponse().getWriter().write(string);
                }
                catch (Exception exception2) {
                    LOGGER.error("Error writing first exception to response", (Throwable)exception2);
                }
            }
            finally {
                try {
                    extAsyncContext.complete();
                }
                catch (Exception exception) {
                    LOGGER.error("Error completing async context", (Throwable)exception);
                }
            }
        });
    }

    @Override
    public void onRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) throws ServletException, IOException {
        if (this.m_aAsyncSpec.isAsynchronous() && httpServletRequest.isAsyncSupported()) {
            iRequestWebScope.attrs().putIn((Object)"$ph-request-is-async", true);
            this._handleAsync(httpServletRequest, httpServletResponse, eHttpVersion, eHttpMethod, iRequestWebScope);
        } else {
            this.m_aNestedHandler.onRequest(httpServletRequest, httpServletResponse, eHttpVersion, eHttpMethod, iRequestWebScope);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("AsyncSpec", (Object)this.m_aAsyncSpec).append("OriginalHandler", (Object)this.m_aNestedHandler).getToString();
    }
}

