/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.requesttrack;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RequestTrackerSettings {
    public static final boolean DEFAULT_LONG_RUNNING_CHECK_ENABLED = true;
    public static final long DEFAULT_LONG_RUNNING_REQUESTS_CHECK_INTERVAL_MILLISECONDS = 2000L;
    public static final long DEFAULT_LONG_RUNNING_NOTIFICATION_MILLISECONDS = 30000L;
    public static final boolean DEFAULT_PARALLEL_RUNNING_REQUESTS_CHECK_ENABLED = true;
    public static final int DEFAULT_PARALLEL_RUNNING_REQUESTS_BARRIER = 60;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static boolean s_bLRCheckEnabled = true;
    private static long s_nLRCheckMilliseconds = 2000L;
    private static long s_nLRMinDurationMilliseconds = 30000L;
    private static boolean s_bPRCheckEnabled = true;
    private static int s_nParallelRunningRequestBarrier = 60;

    private RequestTrackerSettings() {
    }

    public static boolean isLongRunningRequestsCheckEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bLRCheckEnabled);
    }

    public static void setLongRunningRequestsCheckEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bLRCheckEnabled = bl;
        });
    }

    @Nonnegative
    public static long getLongRunningRequestCheckIntervalMilliseconds() {
        return RW_LOCK.readLockedLong(() -> s_nLRCheckMilliseconds);
    }

    public static void setLongRunningRequestCheckIntervalMilliseconds(@Nonnegative long l) {
        ValueEnforcer.isGT0((long)l, (String)"Seconds");
        RW_LOCK.writeLocked(() -> {
            s_nLRCheckMilliseconds = l;
        });
    }

    @Nonnegative
    public static long getLongRunningRequestWarnDurationMillis() {
        return RW_LOCK.readLockedLong(() -> s_nLRMinDurationMilliseconds);
    }

    public static void setLongRunningRequestWarnDurationMillis(@Nonnegative long l) {
        ValueEnforcer.isGT0((long)l, (String)"Milliseconds");
        RW_LOCK.writeLocked(() -> {
            s_nLRMinDurationMilliseconds = l;
        });
    }

    public static boolean isParallelRunningRequestsCheckEnabled() {
        return RW_LOCK.readLockedBoolean(() -> s_bPRCheckEnabled);
    }

    public static void setParallelRunningRequestsCheckEnabled(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bPRCheckEnabled = bl;
        });
    }

    @Nonnegative
    public static int getParallelRunningRequestBarrier() {
        return RW_LOCK.readLockedInt(() -> s_nParallelRunningRequestBarrier);
    }

    public static void setParallelRunningRequestBarrier(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"ParallelRunningRequestBarrier");
        RW_LOCK.writeLocked(() -> {
            s_nParallelRunningRequestBarrier = n;
        });
    }
}

