/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.immutable.collection.encoding;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class ImmutableListEncoding<T> {
    private ImmutableList<T> field = ImmutableList.of();

    ImmutableList<T> getImmutableList() {
        return this.field;
    }

    List<T> getList() {
        return this.field;
    }

    ImmutableList<T> withCollectionVarargs(T ... elements) {
        return ImmutableList.copyOf((Object[])elements);
    }

    ImmutableList<T> withCollection(Iterable<? extends T> elements) {
        return ImmutableList.copyOf(elements);
    }

    static <T> ImmutableList<T> of(Collection<? extends T> input) {
        return ImmutableList.copyOf(input);
    }

    static class Builder<T> {
        private ImmutableList<T> list = null;
        private ImmutableList.Builder<T> builder = null;

        Builder() {
        }

        void add(T ... element) {
            if (this.builder != null) {
                this.builder.add((Object[])element);
            } else if (this.list != null) {
                this.builder = ImmutableList.builderWithExpectedSize((int)(this.list.size() + 1)).addAll(this.list).add((Object[])element);
                this.list = null;
            } else {
                this.builder = ImmutableList.builder();
                this.builder.add((Object[])element);
            }
        }

        void addAll(Iterable<? extends T> elements) {
            if (this.builder != null) {
                this.builder.addAll(elements);
            } else if (this.list != null) {
                int additionalSize = 0;
                if (elements instanceof Collection) {
                    additionalSize = ((Collection)elements).size();
                }
                this.builder = ImmutableList.builderWithExpectedSize((int)(this.list.size() + additionalSize)).addAll(this.list).addAll(elements);
                this.list = null;
            } else if (elements instanceof ImmutableCollection) {
                this.set(elements);
            } else if (elements instanceof Collection) {
                this.builder = ImmutableList.builderWithExpectedSize((int)((Collection)elements).size());
                this.builder.addAll(elements);
            } else {
                this.builder = ImmutableList.builder();
                this.builder.addAll(elements);
            }
        }

        void set(Iterable<? extends T> input) {
            this.list = ImmutableList.copyOf(input);
            this.builder = null;
        }

        ImmutableList<T> build() {
            if (this.builder != null) {
                return this.builder.build();
            }
            if (this.list != null) {
                return this.list;
            }
            return ImmutableList.of();
        }
    }
}

