/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.font.TrueTypeCollection;
import com.itextpdf.io.util.FileUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FontRegisterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontRegisterProvider.class);
    private final Map<String, String> fontNames = new HashMap<String, String>();
    private static String[] TTFamilyOrder = new String[]{"3", "1", "1033", "3", "0", "1033", "1", "0", "0", "0", "3", "0"};
    private final Map<String, List<String>> fontFamilies = new HashMap<String, List<String>>();

    FontRegisterProvider() {
        this.fontNames.put("Courier".toLowerCase(), "Courier");
        this.fontNames.put("Courier-Bold".toLowerCase(), "Courier-Bold");
        this.fontNames.put("Courier-Oblique".toLowerCase(), "Courier-Oblique");
        this.fontNames.put("Courier-BoldOblique".toLowerCase(), "Courier-BoldOblique");
        this.fontNames.put("Helvetica".toLowerCase(), "Helvetica");
        this.fontNames.put("Helvetica-Bold".toLowerCase(), "Helvetica-Bold");
        this.fontNames.put("Helvetica-Oblique".toLowerCase(), "Helvetica-Oblique");
        this.fontNames.put("Helvetica-BoldOblique".toLowerCase(), "Helvetica-BoldOblique");
        this.fontNames.put("Symbol".toLowerCase(), "Symbol");
        this.fontNames.put("Times-Roman".toLowerCase(), "Times-Roman");
        this.fontNames.put("Times-Bold".toLowerCase(), "Times-Bold");
        this.fontNames.put("Times-Italic".toLowerCase(), "Times-Italic");
        this.fontNames.put("Times-BoldItalic".toLowerCase(), "Times-BoldItalic");
        this.fontNames.put("ZapfDingbats".toLowerCase(), "ZapfDingbats");
        ArrayList<String> family = new ArrayList<String>();
        family.add("Courier");
        family.add("Courier-Bold");
        family.add("Courier-Oblique");
        family.add("Courier-BoldOblique");
        this.fontFamilies.put("Courier".toLowerCase(), family);
        family = new ArrayList();
        family.add("Helvetica");
        family.add("Helvetica-Bold");
        family.add("Helvetica-Oblique");
        family.add("Helvetica-BoldOblique");
        this.fontFamilies.put("Helvetica".toLowerCase(), family);
        family = new ArrayList();
        family.add("Symbol");
        this.fontFamilies.put("Symbol".toLowerCase(), family);
        family = new ArrayList();
        family.add("Times-Roman");
        family.add("Times-Bold");
        family.add("Times-Italic");
        family.add("Times-BoldItalic");
        this.fontFamilies.put("Times".toLowerCase(), family);
        this.fontFamilies.put("Times-Roman".toLowerCase(), family);
        family = new ArrayList();
        family.add("ZapfDingbats");
        this.fontFamilies.put("ZapfDingbats".toLowerCase(), family);
    }

    FontProgram getFont(String fontName, int style) throws java.io.IOException {
        return this.getFont(fontName, style, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FontProgram getFont(String fontName, int style, boolean cached) throws java.io.IOException {
        if (fontName == null) {
            return null;
        }
        String lowerCaseFontName = fontName.toLowerCase();
        List<String> family = this.fontFamilies.get(lowerCaseFontName);
        if (family != null) {
            List<String> list = family;
            synchronized (list) {
                int s = style == -1 ? 0 : style;
                int fs = 0;
                boolean found = false;
                for (String f : family) {
                    String lcf = f.toLowerCase();
                    fs = 0;
                    if (lcf.contains("bold")) {
                        fs |= 1;
                    }
                    if (lcf.contains("italic") || lcf.contains("oblique")) {
                        fs |= 2;
                    }
                    if ((s & 3) != fs) continue;
                    fontName = f;
                    found = true;
                    break;
                }
                if (style != -1 && found) {
                    style &= ~fs;
                }
            }
        }
        return this.getFontProgram(fontName, cached);
    }

    protected FontProgram getFontProgram(String fontName, boolean cached) throws java.io.IOException {
        FontProgram fontProgram = null;
        if ((fontName = this.fontNames.get(fontName.toLowerCase())) != null) {
            fontProgram = FontProgramFactory.createFont(fontName, cached);
        }
        if (fontProgram == null) {
            try {
                fontProgram = FontProgramFactory.createFont(fontName, cached);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return fontProgram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerFontFamily(String familyName, String fullName, String path) {
        List<String> family;
        if (path != null) {
            this.fontNames.put(fullName, path);
        }
        Object object = this.fontFamilies;
        synchronized (object) {
            family = this.fontFamilies.get(familyName);
            if (family == null) {
                family = new ArrayList<String>();
                this.fontFamilies.put(familyName, family);
            }
        }
        object = family;
        synchronized (object) {
            if (!family.contains(fullName)) {
                int fullNameLength = fullName.length();
                boolean inserted = false;
                for (int j = 0; j < family.size(); ++j) {
                    if (family.get(j).length() < fullNameLength) continue;
                    family.add(j, fullName);
                    inserted = true;
                    break;
                }
                if (!inserted) {
                    family.add(fullName);
                    String newFullName = fullName.toLowerCase();
                    if (newFullName.endsWith("regular")) {
                        newFullName = newFullName.substring(0, newFullName.length() - 7).trim();
                        family.add(0, fullName.substring(0, newFullName.length()));
                    }
                }
            }
        }
    }

    void registerFont(String path) {
        this.registerFont(path, null);
    }

    void registerFont(String path, String alias) {
        try {
            if (path.toLowerCase().endsWith(".ttf") || path.toLowerCase().endsWith(".otf") || path.toLowerCase().indexOf(".ttc,") > 0) {
                String[][] names;
                FontProgram fontProgram = FontProgramFactory.createFont(path);
                Object[] allNames = new Object[]{fontProgram.getFontNames().getFontName(), fontProgram.getFontNames().getFamilyName(), fontProgram.getFontNames().getFullName()};
                this.fontNames.put(((String)allNames[0]).toLowerCase(), path);
                if (alias != null) {
                    String lcAlias = alias.toLowerCase();
                    this.fontNames.put(lcAlias, path);
                    if (lcAlias.endsWith("regular")) {
                        this.saveCopyOfRegularFont(lcAlias, path);
                    }
                }
                for (String[] name : names = (String[][])allNames[2]) {
                    String lcName = name[3].toLowerCase();
                    this.fontNames.put(lcName, path);
                    if (!lcName.endsWith("regular")) continue;
                    this.saveCopyOfRegularFont(lcName, path);
                }
                String familyName = null;
                names = (String[][])allNames[1];
                block3: for (int k = 0; k < TTFamilyOrder.length; k += 3) {
                    for (String[] name : names) {
                        if (!TTFamilyOrder[k].equals(name[0]) || !TTFamilyOrder[k + 1].equals(name[1]) || !TTFamilyOrder[k + 2].equals(name[2])) continue;
                        familyName = name[3].toLowerCase();
                        k = TTFamilyOrder.length;
                        continue block3;
                    }
                }
                if (familyName != null) {
                    String lastName = "";
                    block5: for (String[] name : names = (String[][])allNames[2]) {
                        for (int k = 0; k < TTFamilyOrder.length; k += 3) {
                            String fullName;
                            if (!TTFamilyOrder[k].equals(name[0]) || !TTFamilyOrder[k + 1].equals(name[1]) || !TTFamilyOrder[k + 2].equals(name[2]) || (fullName = name[3]).equals(lastName)) continue;
                            lastName = fullName;
                            this.registerFontFamily(familyName, fullName, null);
                            continue block5;
                        }
                    }
                }
            } else if (path.toLowerCase().endsWith(".ttc")) {
                TrueTypeCollection ttc = new TrueTypeCollection(path);
                for (int i = 0; i < ttc.getTTCSize(); ++i) {
                    String fullPath = path + "," + i;
                    if (alias != null) {
                        this.registerFont(fullPath, alias + "," + i);
                        continue;
                    }
                    this.registerFont(fullPath);
                }
            } else if (path.toLowerCase().endsWith(".afm") || path.toLowerCase().endsWith(".pfm")) {
                FontProgram fontProgram = FontProgramFactory.createFont(path);
                String fullName = fontProgram.getFontNames().getFullName()[0][3].toLowerCase();
                String familyName = fontProgram.getFontNames().getFamilyName()[0][3].toLowerCase();
                String psName = fontProgram.getFontNames().getFontName().toLowerCase();
                this.registerFontFamily(familyName, fullName, null);
                this.fontNames.put(psName, path);
                this.fontNames.put(fullName, path);
            }
            LOGGER.trace(MessageFormat.format("Registered {0}", path));
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    boolean saveCopyOfRegularFont(String regularFontName, String path) {
        String alias = regularFontName.substring(0, regularFontName.length() - 7).trim();
        if (!this.fontNames.containsKey(alias)) {
            this.fontNames.put(alias, path);
            return true;
        }
        return false;
    }

    int registerFontDirectory(String dir) {
        return this.registerFontDirectory(dir, false);
    }

    int registerFontDirectory(String dir, boolean scanSubdirectories) {
        LOGGER.debug(MessageFormat.format("Registering directory {0}, looking for fonts", dir));
        int count = 0;
        try {
            String[] files = FileUtil.listFilesInDirectory(dir, scanSubdirectories);
            if (files == null) {
                return 0;
            }
            for (String file : files) {
                try {
                    String suffix;
                    String string = suffix = file.length() < 4 ? null : file.substring(file.length() - 4).toLowerCase();
                    if (".afm".equals(suffix) || ".pfm".equals(suffix)) {
                        String pfb = file.substring(0, file.length() - 4) + ".pfb";
                        if (!FileUtil.fileExists(pfb)) continue;
                        this.registerFont(file, null);
                        ++count;
                        continue;
                    }
                    if (!".ttf".equals(suffix) && !".otf".equals(suffix) && !".ttc".equals(suffix)) continue;
                    this.registerFont(file, null);
                    ++count;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    int registerSystemFontDirectories() {
        String[] withoutSubDirs;
        String[] withSubDirs;
        int count = 0;
        for (String directory : withSubDirs = new String[]{FileUtil.getFontsDir(), "/usr/share/X11/fonts", "/usr/X/lib/X11/fonts", "/usr/openwin/lib/X11/fonts", "/usr/share/fonts", "/usr/X11R6/lib/X11/fonts"}) {
            count += this.registerFontDirectory(directory, true);
        }
        for (String directory : withoutSubDirs = new String[]{"/Library/Fonts", "/System/Library/Fonts"}) {
            count += this.registerFontDirectory(directory, false);
        }
        return count;
    }

    Set<String> getRegisteredFonts() {
        return this.fontNames.keySet();
    }

    Set<String> getRegisteredFontFamilies() {
        return this.fontFamilies.keySet();
    }

    boolean isRegisteredFont(String fontname) {
        return this.fontNames.containsKey(fontname.toLowerCase());
    }
}

