/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.cmap.AbstractCMap;
import com.itextpdf.io.font.cmap.CMapObject;
import java.util.ArrayList;
import java.util.List;

public class CMapByteCid
extends AbstractCMap {
    private List<char[]> planes = new ArrayList<char[]>();

    public CMapByteCid() {
        this.planes.add(new char[256]);
    }

    @Override
    void addChar(String mark, CMapObject code) {
        if (code.isNumber()) {
            this.encodeSequence(CMapByteCid.decodeStringToByte(mark), ((Character)code.getValue()).charValue());
        }
    }

    public String decodeSequence(byte[] cidBytes, int offset, int length) {
        int cid;
        StringBuilder sb = new StringBuilder();
        Cursor cursor = new Cursor(offset, length);
        while ((cid = this.decodeSingle(cidBytes, cursor)) >= 0) {
            sb.append((char)cid);
        }
        return sb.toString();
    }

    protected int decodeSingle(byte[] cidBytes, Cursor cursor) {
        int end = cursor.offset + cursor.length;
        int currentPlane = 0;
        while (cursor.offset < end) {
            int one = cidBytes[cursor.offset++] & 0xFF;
            --cursor.length;
            char[] plane = this.planes.get(currentPlane);
            char cid = plane[one];
            if ((cid & 0x8000) == 0) {
                return cid;
            }
            currentPlane = cid & Short.MAX_VALUE;
        }
        return -1;
    }

    private void encodeSequence(byte[] seq, char cid) {
        int one;
        int size = seq.length - 1;
        int nextPlane = 0;
        for (int idx = 0; idx < size; ++idx) {
            int one2;
            char[] plane = this.planes.get(nextPlane);
            char c = plane[one2 = seq[idx] & 0xFF];
            if (c != '\u0000' && (c & 0x8000) == 0) {
                throw new IOException("inconsistent.mapping");
            }
            if (c == '\u0000') {
                this.planes.add(new char[256]);
                plane[one2] = c = (char)(this.planes.size() - 1 | 0x8000);
            }
            nextPlane = c & Short.MAX_VALUE;
        }
        char[] plane = this.planes.get(nextPlane);
        char c = plane[one = seq[size] & 0xFF];
        if ((c & 0x8000) != 0) {
            throw new IOException("inconsistent.mapping");
        }
        plane[one] = cid;
    }

    protected static class Cursor {
        public int offset;
        public int length;

        public Cursor(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

