/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.AdobeGlyphList;
import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;

class DocFontEncoding
extends FontEncoding {
    private static final long serialVersionUID = -4248206280861742148L;

    protected DocFontEncoding() {
    }

    public static FontEncoding createDocFontEncoding(PdfObject encoding, CMapToUnicode toUnicode, boolean fillStandardEncoding) {
        if (encoding != null) {
            if (encoding.isName()) {
                return FontEncoding.createFontEncoding((String)((PdfName)encoding).getValue());
            }
            if (encoding.isDictionary()) {
                DocFontEncoding fontEncoding = new DocFontEncoding();
                fontEncoding.differences = new String[256];
                DocFontEncoding.fillBaseEncoding(fontEncoding, ((PdfDictionary)encoding).getAsName(PdfName.BaseEncoding), fillStandardEncoding);
                DocFontEncoding.fillDifferences(fontEncoding, ((PdfDictionary)encoding).getAsArray(PdfName.Differences), toUnicode);
                return fontEncoding;
            }
        }
        if (toUnicode != null) {
            DocFontEncoding fontEncoding = new DocFontEncoding();
            fontEncoding.differences = new String[256];
            DocFontEncoding.fillDifferences(fontEncoding, toUnicode);
            return fontEncoding;
        }
        return FontEncoding.createFontSpecificEncoding();
    }

    private static void fillBaseEncoding(DocFontEncoding fontEncoding, PdfName baseEncodingName, boolean fillStandardEncoding) {
        if (baseEncodingName != null) {
            fontEncoding.baseEncoding = baseEncodingName.getValue();
        }
        if (PdfName.MacRomanEncoding.equals(baseEncodingName) || PdfName.WinAnsiEncoding.equals(baseEncodingName) || PdfName.Symbol.equals(baseEncodingName) || PdfName.ZapfDingbats.equals(baseEncodingName)) {
            String enc = "Cp1252";
            if (PdfName.MacRomanEncoding.equals(baseEncodingName)) {
                enc = "MacRoman";
            } else if (PdfName.Symbol.equals(baseEncodingName)) {
                enc = "Symbol";
            } else if (PdfName.ZapfDingbats.equals(baseEncodingName)) {
                enc = "ZapfDingbats";
            }
            fontEncoding.baseEncoding = enc;
            fontEncoding.fillNamedEncoding();
        } else if (fillStandardEncoding) {
            fontEncoding.fillStandardEncoding();
        }
    }

    private static void fillDifferences(DocFontEncoding fontEncoding, PdfArray diffs, CMapToUnicode toUnicode) {
        IntHashtable byte2uni;
        IntHashtable intHashtable = byte2uni = toUnicode != null ? toUnicode.createDirectMapping() : new IntHashtable();
        if (diffs != null) {
            int currentNumber = 0;
            for (int k = 0; k < diffs.size(); ++k) {
                PdfObject obj = diffs.get(k);
                if (obj.isNumber()) {
                    currentNumber = ((PdfNumber)obj).intValue();
                    continue;
                }
                String glyphName = ((PdfName)obj).getValue();
                int unicode = AdobeGlyphList.nameToUnicode((String)glyphName);
                if (unicode != -1) {
                    fontEncoding.codeToUnicode[currentNumber] = unicode;
                    fontEncoding.unicodeToCode.put(unicode, currentNumber);
                    fontEncoding.differences[currentNumber] = glyphName;
                    fontEncoding.unicodeDifferences.put(unicode, unicode);
                } else if (byte2uni.contains(currentNumber)) {
                    fontEncoding.codeToUnicode[currentNumber] = unicode = byte2uni.get(currentNumber);
                    fontEncoding.unicodeToCode.put(unicode, currentNumber);
                    fontEncoding.differences[currentNumber] = glyphName;
                    fontEncoding.unicodeDifferences.put(unicode, unicode);
                }
                ++currentNumber;
            }
        }
    }

    private static void fillDifferences(DocFontEncoding fontEncoding, CMapToUnicode toUnicode) {
        IntHashtable byte2uni = toUnicode.createDirectMapping();
        int[] nArray = byte2uni.getKeys();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer code = nArray[i];
            int unicode = byte2uni.get(code.intValue());
            String glyphName = AdobeGlyphList.unicodeToName((int)unicode);
            fontEncoding.codeToUnicode[code.intValue()] = unicode;
            fontEncoding.unicodeToCode.put(unicode, code.intValue());
            fontEncoding.differences[code.intValue()] = glyphName;
            fontEncoding.unicodeDifferences.put(unicode, unicode);
        }
    }
}

