/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PageRange {
    private List<Integer> sequenceStarts = new ArrayList<Integer>();
    private List<Integer> sequenceEnds = new ArrayList<Integer>();

    public PageRange() {
    }

    public PageRange(String pageRange) {
        pageRange = pageRange.replaceAll("\\s+", "");
        Pattern sequencePattern = Pattern.compile("(\\d+)-(\\d+)");
        Pattern singlePagePattern = Pattern.compile("(\\d+)");
        for (String pageRangePart : pageRange.split(",")) {
            Matcher matcher = sequencePattern.matcher(pageRangePart);
            if (matcher.matches()) {
                this.sequenceStarts.add(Integer.parseInt(matcher.group(1)));
                this.sequenceEnds.add(Integer.parseInt(matcher.group(2)));
                continue;
            }
            matcher = singlePagePattern.matcher(pageRangePart);
            if (!matcher.matches()) continue;
            int pageNumber = Integer.parseInt(matcher.group(1));
            this.sequenceStarts.add(pageNumber);
            this.sequenceEnds.add(pageNumber);
        }
    }

    public PageRange addPageSequence(int startPageNumber, int endPageNumber) {
        this.sequenceStarts.add(startPageNumber);
        this.sequenceEnds.add(endPageNumber);
        return this;
    }

    public PageRange addSinglePage(int pageNumber) {
        this.sequenceStarts.add(pageNumber);
        this.sequenceEnds.add(pageNumber);
        return this;
    }

    public List<Integer> getAllPages() {
        ArrayList<Integer> allPages = new ArrayList<Integer>();
        for (int ind = 0; ind < this.sequenceStarts.size(); ++ind) {
            for (int pageInRange = this.sequenceStarts.get(ind).intValue(); pageInRange <= this.sequenceEnds.get(ind); ++pageInRange) {
                allPages.add(pageInRange);
            }
        }
        return allPages;
    }

    public boolean isPageInRange(int pageNumber) {
        for (int ind = 0; ind < this.sequenceStarts.size(); ++ind) {
            if (this.sequenceStarts.get(ind) > pageNumber || pageNumber > this.sequenceEnds.get(ind)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PageRange)) {
            return false;
        }
        PageRange other = (PageRange)obj;
        return this.sequenceStarts.equals(other.sequenceStarts) && this.sequenceEnds.equals(other.sequenceEnds);
    }

    public int hashCode() {
        return this.sequenceStarts.hashCode() * 31 + this.sequenceEnds.hashCode();
    }
}

