/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner;

import com.klarna.hiverunner.TimeoutException;
import com.klarna.hiverunner.config.HiveRunnerConfig;
import org.apache.commons.lang.time.StopWatch;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrowOnTimeout
extends Statement {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrowOnTimeout.class);
    private final Statement originalStatement;
    private final HiveRunnerConfig config;
    private Object target;
    private Throwable statementException;
    private boolean finished = false;

    public ThrowOnTimeout(Statement originalStatement, HiveRunnerConfig config, Object target) {
        this.originalStatement = originalStatement;
        this.config = config;
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        final StopWatch stopWatch = new StopWatch();
        if (this.config.isTimeoutEnabled()) {
            LOGGER.info("Starting timeout monitoring ({}s) of test case {}.", (Object)this.config.getTimeoutSeconds(), this.target);
        }
        Thread statementThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    stopWatch.start();
                    ThrowOnTimeout.this.originalStatement.evaluate();
                    ThrowOnTimeout.this.finished = true;
                }
                catch (InterruptedException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                catch (Throwable e) {
                    Object object = ThrowOnTimeout.this.target;
                    synchronized (object) {
                        ThrowOnTimeout.this.statementException = e;
                    }
                }
            }
        });
        statementThread.start();
        statementThread.join(this.config.getTimeoutSeconds() * 1000);
        Object object = this.target;
        synchronized (object) {
            if (this.statementException != null) {
                throw this.statementException;
            }
            if (!this.finished) {
                if (this.config.isTimeoutEnabled()) {
                    statementThread.interrupt();
                    throw new TimeoutException(String.format("test timed out after %d seconds", this.config.getTimeoutSeconds()));
                }
                LOGGER.warn("Test ran for {} seconds. Timeout disabled. See class {} for configuration options.", (Object)(stopWatch.getTime() / 1000L), (Object)HiveRunnerConfig.class.getName());
            }
        }
        statementThread.join();
        if (this.statementException != null) {
            throw this.statementException;
        }
    }

    public static TestRule create(final HiveRunnerConfig config, final Object target) {
        return new TestRule(){

            public Statement apply(Statement base, Description description) {
                return new ThrowOnTimeout(base, config, target);
            }
        };
    }
}

