/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.config;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRunnerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveRunnerConfig.class);
    public static final String ENABLE_TIMEOUT_PROPERTY_NAME = "enableTimeout";
    public static final boolean ENABLE_TIMEOUT_DEFAULT = false;
    public static final String TIMEOUT_SECONDS_PROPERTY_NAME = "timeoutSeconds";
    public static final int TIMEOUT_SECONDS_DEFAULT = 30;
    public static final String TIMEOUT_RETRIES_PROPERTY_NAME = "timeoutRetries";
    public static final int TIMEOUT_RETRIES_DEFAULT = 2;
    public static final String HIVECONF_SYSTEM_OVERRIDE_PREFIX = "hiveconf_";
    private Map<String, Object> config = new HashMap<String, Object>();
    private Map<String, String> hiveConfSystemOverride = new HashMap<String, String>();

    public HiveRunnerConfig() {
        this(System.getProperties());
    }

    public HiveRunnerConfig(Properties systemProperties) {
        this.config.put(ENABLE_TIMEOUT_PROPERTY_NAME, HiveRunnerConfig.load(ENABLE_TIMEOUT_PROPERTY_NAME, false, systemProperties));
        this.config.put(TIMEOUT_RETRIES_PROPERTY_NAME, HiveRunnerConfig.load(TIMEOUT_RETRIES_PROPERTY_NAME, 2, systemProperties));
        this.config.put(TIMEOUT_SECONDS_PROPERTY_NAME, HiveRunnerConfig.load(TIMEOUT_SECONDS_PROPERTY_NAME, 30, systemProperties));
        this.hiveConfSystemOverride = this.loadHiveConfSystemOverrides(systemProperties);
    }

    public boolean isTimeoutEnabled() {
        return this.getBoolean(ENABLE_TIMEOUT_PROPERTY_NAME);
    }

    public int getTimeoutRetries() {
        return this.getInteger(TIMEOUT_RETRIES_PROPERTY_NAME);
    }

    public int getTimeoutSeconds() {
        return this.getInteger(TIMEOUT_SECONDS_PROPERTY_NAME);
    }

    public String getHiveExecutionEngine() {
        String executionEngine = this.hiveConfSystemOverride.get(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname);
        return executionEngine == null ? HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.getDefaultValue() : executionEngine;
    }

    public Map<String, String> getHiveConfSystemOverride() {
        return this.hiveConfSystemOverride;
    }

    public void setTimeoutEnabled(boolean isEnabled) {
        this.config.put(ENABLE_TIMEOUT_PROPERTY_NAME, isEnabled);
    }

    public void setTimeoutRetries(int retries) {
        this.config.put(TIMEOUT_RETRIES_PROPERTY_NAME, retries);
    }

    public void setTimeoutSeconds(int timeout) {
        this.config.put(TIMEOUT_SECONDS_PROPERTY_NAME, timeout);
    }

    public void setHiveExecutionEngine(String executionEngine) {
        this.hiveConfSystemOverride.put(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, executionEngine);
    }

    public void override(HiveRunnerConfig hiveRunnerConfig) {
        this.config.putAll(hiveRunnerConfig.config);
        this.hiveConfSystemOverride.putAll(hiveRunnerConfig.hiveConfSystemOverride);
    }

    private String load(String property, String defaultValue, List<String> validValues, Properties sysProperties) {
        String value = HiveRunnerConfig.load(property, defaultValue, sysProperties);
        Preconditions.checkArgument((boolean)validValues.contains(value), (Object)("Invalid value of system property '" + property + "': Only values '" + validValues + "' are allowed"));
        return value;
    }

    private static boolean load(String property, boolean defaultValue, Properties sysProperties) {
        String value = sysProperties.getProperty(property);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private static String load(String property, String defaultValue, Properties sysProperties) {
        String value = sysProperties.getProperty(property);
        return value == null ? defaultValue : value;
    }

    private static int load(String property, int defaultValue, Properties sysProperties) {
        String value = sysProperties.getProperty(property);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    private boolean getBoolean(String key) {
        return (Boolean)this.config.get(key);
    }

    private int getInteger(String key) {
        return (Integer)this.config.get(key);
    }

    private String getString(String key) {
        return (String)this.config.get(key);
    }

    private Map<String, String> loadHiveConfSystemOverrides(Properties systemProperties) {
        HashMap<String, String> hiveConfSystemOverride = new HashMap<String, String>();
        for (String sysKey : systemProperties.stringPropertyNames()) {
            if (!sysKey.startsWith(HIVECONF_SYSTEM_OVERRIDE_PREFIX)) continue;
            String hiveConfKey = sysKey.substring(HIVECONF_SYSTEM_OVERRIDE_PREFIX.length());
            hiveConfSystemOverride.put(hiveConfKey, systemProperties.getProperty(sysKey));
        }
        return hiveConfSystemOverride;
    }
}

