/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.lang.builder.ToStringBuilder;

class HiveResource {
    private final String targetFile;
    private final ByteArrayOutputStream byteArrayOutputStream;

    HiveResource(String targetFile) throws IOException {
        this(targetFile, new ByteArrayOutputStream());
    }

    HiveResource(String targetFile, Path dataFile) throws IOException {
        this(targetFile, HiveResource.createOutputStream(Files.readAllBytes(dataFile)));
    }

    HiveResource(String targetFile, String data) throws IOException {
        this(targetFile, HiveResource.createOutputStream(data.getBytes()));
    }

    private HiveResource(String targetFile, ByteArrayOutputStream byteArrayOutputStream) {
        this.targetFile = targetFile;
        this.byteArrayOutputStream = byteArrayOutputStream;
    }

    private static ByteArrayOutputStream createOutputStream(byte[] data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(data);
        baos.close();
        return baos;
    }

    String getTargetFile() {
        return this.targetFile;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.byteArrayOutputStream;
    }
}

