/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class StatementsSplitter {
    public static final Pattern START_OF_COMMENT_PATTERN = Pattern.compile(".*\\s--", 32);
    public static final Pattern LAST_CHAR_NOT_ESCAPED_PATTERN = Pattern.compile(".*[^\\\\].", 32);
    public static final String SQL_SPECIAL_CHARS = ";\"'-\n";

    public static List<String> splitStatements(String expression) {
        StringTokenizer tokenizer = new StringTokenizer(expression, SQL_SPECIAL_CHARS, true);
        ArrayList<String> statements = new ArrayList<String>();
        String statement = "";
        block11: while (tokenizer.hasMoreElements()) {
            String token;
            switch (token = (String)tokenizer.nextElement()) {
                case ";": {
                    if (StatementsSplitter.isValidStatement(statement)) {
                        statements.add(statement.trim());
                    }
                    statement = "";
                    continue block11;
                }
                case "-": {
                    if (!START_OF_COMMENT_PATTERN.matcher(statement = statement + token).matches()) continue block11;
                    statement = statement + StatementsSplitter.readUntilEndOfLine(tokenizer);
                    continue block11;
                }
                case "\"": 
                case "'": {
                    statement = statement + StatementsSplitter.readQuoted(tokenizer, token);
                    continue block11;
                }
            }
            statement = statement + token;
        }
        if (StatementsSplitter.isValidStatement(statement)) {
            statements.add(statement);
        }
        return statements;
    }

    private static boolean isValidStatement(String statement) {
        return statement.trim().length() > 0;
    }

    static String readUntilEndOfLine(StringTokenizer tokenizer) {
        String statement = "";
        while (tokenizer.hasMoreElements() && !(statement = statement + tokenizer.nextElement()).endsWith("\n")) {
        }
        return statement;
    }

    static String readQuoted(StringTokenizer tokenizer, String startQuoteToken) {
        String quotedString = startQuoteToken;
        while (!(!tokenizer.hasMoreElements() || (quotedString = quotedString + (String)tokenizer.nextElement()).endsWith(startQuoteToken) && LAST_CHAR_NOT_ESCAPED_PATTERN.matcher(quotedString).matches())) {
        }
        return quotedString;
    }
}

