/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.mojo;

import com.lazerycode.jmeter.configuration.JMeterArgumentsArray;
import com.lazerycode.jmeter.json.TestConfig;
import com.lazerycode.jmeter.mojo.AbstractJMeterMojo;
import com.lazerycode.jmeter.mojo.JMeterConfigurationHolder;
import com.lazerycode.jmeter.testrunner.JMeterProcessBuilder;
import com.lazerycode.jmeter.utility.UtilityFunctions;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="gui", defaultPhase=LifecyclePhase.TEST)
@Execute(goal="configure")
public class RunJMeterGUIMojo
extends AbstractJMeterMojo {
    @Parameter(defaultValue="false")
    private boolean runInBackground;
    @Parameter
    private File guiTestFile;
    private JMeterArgumentsArray testArgs;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.getLog().info((CharSequence)" S T A R T I N G    J M E T E R    G U I ");
        this.getLog().info((CharSequence)"-------------------------------------------------------");
        this.initialiseJMeterArgumentsArray(false);
        this.getLog().debug((CharSequence)("JMeter is called with the following command line arguments: " + UtilityFunctions.humanReadableCommandLineOutput(this.testArgs.buildArgumentsArray())));
        this.startJMeterGUI();
    }

    private void initialiseJMeterArgumentsArray(boolean disableGUI) throws MojoExecutionException {
        TestConfig testConfig = new TestConfig(new File(this.testConfigFile));
        JMeterArgumentsArray localTestArgs = this.computeJMeterArgumentsArray(disableGUI, testConfig.getResultsOutputIsCSVFormat());
        localTestArgs.setTestFile(this.guiTestFile, this.testFilesDirectory);
        this.testArgs = localTestArgs;
    }

    private void startJMeterGUI() throws MojoExecutionException {
        JMeterProcessBuilder jmeterProcessBuilder = new JMeterProcessBuilder(this.jMeterProcessJVMSettings, JMeterConfigurationHolder.getInstance().getRuntimeJarName());
        jmeterProcessBuilder.setWorkingDirectory(JMeterConfigurationHolder.getInstance().getWorkingDirectory());
        jmeterProcessBuilder.addArguments(this.testArgs.buildArgumentsArray());
        try {
            Process process = jmeterProcessBuilder.startProcess();
            if (!this.runInBackground) {
                process.waitFor();
            }
        }
        catch (InterruptedException ex) {
            this.getLog().info((CharSequence)" ");
            this.getLog().info((CharSequence)"System Exit Detected!  Stopping GUI...");
            this.getLog().info((CharSequence)" ");
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error starting JMeter with args " + this.testArgs.buildArgumentsArray() + ", in working directory:" + JMeterConfigurationHolder.getInstance().getWorkingDirectory()), (Throwable)e);
        }
    }
}

