/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.kernel;

import aQute.bnd.annotation.ProviderType;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.collections.ServiceRegistrationMapImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ProviderType
public class AssetRendererFactoryRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(AssetRendererFactoryRegistryUtil.class);
    private static final AssetRendererFactoryRegistryUtil _instance = new AssetRendererFactoryRegistryUtil();
    private final Map<String, AssetRendererFactory<?>> _assetRenderFactoriesMapByClassName = new ConcurrentHashMap();
    private final Map<String, AssetRendererFactory<?>> _assetRenderFactoriesMapByClassType = new ConcurrentHashMap();
    private final ServiceRegistrationMap<AssetRendererFactory<?>> _serviceRegistrations = new ServiceRegistrationMapImpl();
    private final ServiceTracker<AssetRendererFactory<?>, AssetRendererFactory<?>> _serviceTracker;

    public static List<AssetRendererFactory<?>> getAssetRendererFactories(long companyId) {
        return _instance._getAssetRendererFactories(companyId);
    }

    public static <T> AssetRendererFactory<T> getAssetRendererFactoryByClass(Class<T> clazz) {
        return _instance._getAssetRendererFactoryByClass(clazz);
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByClassName(String className) {
        return _instance._getAssetRendererFactoryByClassName(className);
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByClassNameId(long classNameId) {
        return _instance._getAssetRendererFactoryByClassNameId(classNameId);
    }

    public static AssetRendererFactory<?> getAssetRendererFactoryByType(String type) {
        return _instance._getAssetRendererFactoryByType(type);
    }

    public static long[] getClassNameIds(long companyId) {
        return _instance._getClassNameIds(companyId, false);
    }

    public static long[] getClassNameIds(long companyId, boolean filterSelectable) {
        return _instance._getClassNameIds(companyId, filterSelectable);
    }

    public static void register(AssetRendererFactory<?> assetRendererFactory) {
        _instance._register(assetRendererFactory);
    }

    public static void register(List<AssetRendererFactory<?>> assetRendererFactories) {
        for (AssetRendererFactory<?> assetRendererFactory : assetRendererFactories) {
            AssetRendererFactoryRegistryUtil.register(assetRendererFactory);
        }
    }

    public static void unregister(AssetRendererFactory<?> assetRendererFactory) {
        _instance._unregister(assetRendererFactory);
    }

    public static void unregister(List<AssetRendererFactory<?>> assetRendererFactories) {
        for (AssetRendererFactory<?> assetRendererFactory : assetRendererFactories) {
            AssetRendererFactoryRegistryUtil.unregister(assetRendererFactory);
        }
    }

    private AssetRendererFactoryRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(AssetRendererFactory.class, (ServiceTrackerCustomizer)new AssetRendererFactoryServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private Map<String, AssetRendererFactory<?>> _filterAssetRendererFactories(long companyId, Map<String, AssetRendererFactory<?>> assetRendererFactories, boolean filterSelectable) {
        ConcurrentHashMap filteredAssetRendererFactories = new ConcurrentHashMap();
        for (String className : assetRendererFactories.keySet()) {
            AssetRendererFactory<?> assetRendererFactory = assetRendererFactories.get(className);
            if (!assetRendererFactory.isActive(companyId) || filterSelectable && !assetRendererFactory.isSelectable()) continue;
            filteredAssetRendererFactories.put(className, assetRendererFactory);
        }
        return filteredAssetRendererFactories;
    }

    private List<AssetRendererFactory<?>> _getAssetRendererFactories(long companyId) {
        return ListUtil.fromMapValues(this._filterAssetRendererFactories(companyId, this._assetRenderFactoriesMapByClassName, false));
    }

    private <T> AssetRendererFactory<T> _getAssetRendererFactoryByClass(Class<T> clazz) {
        return this._assetRenderFactoriesMapByClassName.get(clazz.getName());
    }

    private AssetRendererFactory<?> _getAssetRendererFactoryByClassName(String className) {
        return this._assetRenderFactoriesMapByClassName.get(className);
    }

    private AssetRendererFactory<?> _getAssetRendererFactoryByClassNameId(long classNameId) {
        return this._getAssetRendererFactoryByClassName(PortalUtil.getClassName(classNameId));
    }

    private AssetRendererFactory<?> _getAssetRendererFactoryByType(String type) {
        return this._assetRenderFactoriesMapByClassType.get(type);
    }

    private long[] _getClassNameIds(long companyId, boolean filterSelectable) {
        Map<String, AssetRendererFactory<?>> assetRenderFactories = this._assetRenderFactoriesMapByClassName;
        if (companyId > 0L) {
            assetRenderFactories = this._filterAssetRendererFactories(companyId, this._assetRenderFactoriesMapByClassName, filterSelectable);
        }
        long[] classNameIds = new long[assetRenderFactories.size()];
        int i = 0;
        for (AssetRendererFactory<?> assetRendererFactory : assetRenderFactories.values()) {
            classNameIds[i] = assetRendererFactory.getClassNameId();
            ++i;
        }
        return classNameIds;
    }

    private void _register(AssetRendererFactory<?> assetRendererFactory) {
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(AssetRendererFactory.class, assetRendererFactory);
        this._serviceRegistrations.put(assetRendererFactory, (Object)serviceRegistration);
    }

    private void _unregister(AssetRendererFactory<?> assetRendererFactory) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove(assetRendererFactory);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class AssetRendererFactoryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AssetRendererFactory<?>, AssetRendererFactory<?>> {
        private AssetRendererFactoryServiceTrackerCustomizer() {
        }

        public AssetRendererFactory<?> addingService(ServiceReference<AssetRendererFactory<?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            AssetRendererFactory assetRendererFactory = (AssetRendererFactory)registry.getService(serviceReference);
            String className = assetRendererFactory.getClassName();
            AssetRendererFactory classNameAssetRendererFactory = AssetRendererFactoryRegistryUtil.this._assetRenderFactoriesMapByClassName.put(className, assetRendererFactory);
            if (_log.isWarnEnabled() && classNameAssetRendererFactory != null) {
                _log.warn("Replacing " + classNameAssetRendererFactory + " for class name " + className + " with " + assetRendererFactory);
            }
            String type = assetRendererFactory.getType();
            AssetRendererFactory typeAssetRendererFactory = AssetRendererFactoryRegistryUtil.this._assetRenderFactoriesMapByClassType.put(type, assetRendererFactory);
            if (_log.isWarnEnabled() && typeAssetRendererFactory != null) {
                _log.warn("Replacing " + typeAssetRendererFactory + " for type " + type + " with " + assetRendererFactory);
            }
            return assetRendererFactory;
        }

        public void modifiedService(ServiceReference<AssetRendererFactory<?>> serviceReference, AssetRendererFactory<?> assetRendererFactory) {
        }

        public void removedService(ServiceReference<AssetRendererFactory<?>> serviceReference, AssetRendererFactory<?> assetRendererFactory) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            AssetRendererFactoryRegistryUtil.this._assetRenderFactoriesMapByClassName.remove(assetRendererFactory.getClassName());
            AssetRendererFactoryRegistryUtil.this._assetRenderFactoriesMapByClassType.remove(assetRendererFactory.getType());
        }
    }
}

