/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache.thread.local;

import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.transaction.NewTransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionLifecycleListener;
import com.liferay.portal.kernel.transaction.TransactionStatus;
import com.liferay.portal.kernel.util.InitialThreadLocal;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class ThreadLocalCacheManager {
    public static final TransactionLifecycleListener TRANSACTION_LIFECYCLE_LISTENER = new NewTransactionLifecycleListener(){

        @Override
        protected void doCommitted(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            if (!transactionAttribute.isReadOnly()) {
                ThreadLocalCacheManager.enable(Lifecycle.REQUEST);
            }
        }

        @Override
        protected void doCreated(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus) {
            if (!transactionAttribute.isReadOnly()) {
                ThreadLocalCacheManager.disable(Lifecycle.REQUEST);
            }
        }

        @Override
        protected void doRollbacked(TransactionAttribute transactionAttribute, TransactionStatus transactionStatus, Throwable throwable) {
            if (!transactionAttribute.isReadOnly()) {
                ThreadLocalCacheManager.enable(Lifecycle.REQUEST);
            }
        }
    };
    private static final EmptyThreadLocalCahce<?> _emptyThreadLocalCache = new EmptyThreadLocalCahce();
    private static final ThreadLocal<Map<Lifecycle, Boolean>> _threadLocalCacheDisabledFlags = new InitialThreadLocal(ThreadLocalCacheManager.class + "._threadLocalCacheDisabledFlags", new EnumMap(Lifecycle.class));
    private static final ThreadLocal<Map<Lifecycle, Map<Serializable, ThreadLocalCache<?>>>> _threadLocalCacheMaps = new InitialThreadLocal(ThreadLocalCacheManager.class + "._threadLocalCacheMaps", new EnumMap(Lifecycle.class));

    public static void clearAll(Lifecycle lifecycle) {
        Map<Lifecycle, Map<Serializable, ThreadLocalCache<?>>> threadLocalCacheMaps = _threadLocalCacheMaps.get();
        Map<Serializable, ThreadLocalCache<?>> threadLocalCacheMap = threadLocalCacheMaps.get((Object)lifecycle);
        if (threadLocalCacheMap != null) {
            threadLocalCacheMap.clear();
        }
    }

    public static void destroy() {
        _threadLocalCacheMaps.remove();
    }

    public static void disable(Lifecycle lifecycle) {
        Map<Lifecycle, Boolean> threadLocalCacheDisabledFlags = _threadLocalCacheDisabledFlags.get();
        threadLocalCacheDisabledFlags.put(lifecycle, Boolean.TRUE);
        ThreadLocalCacheManager.clearAll(lifecycle);
    }

    public static void enable(Lifecycle lifecycle) {
        Map<Lifecycle, Boolean> threadLocalCacheDisabledFlags = _threadLocalCacheDisabledFlags.get();
        threadLocalCacheDisabledFlags.remove((Object)lifecycle);
    }

    public static <T> ThreadLocalCache<T> getThreadLocalCache(Lifecycle lifecycle, Serializable name) {
        ThreadLocalCache<Object> threadLocalCache;
        Map<Lifecycle, Boolean> threadLocalCacheDisabledFlags = _threadLocalCacheDisabledFlags.get();
        if (threadLocalCacheDisabledFlags.get((Object)lifecycle) == Boolean.TRUE) {
            return _emptyThreadLocalCache;
        }
        Map<Lifecycle, Map<Serializable, ThreadLocalCache<?>>> threadLocalCacheMaps = _threadLocalCacheMaps.get();
        Map<Serializable, ThreadLocalCache<?>> threadLocalCacheMap = threadLocalCacheMaps.get((Object)lifecycle);
        if (threadLocalCacheMap == null) {
            threadLocalCacheMap = new HashMap();
            threadLocalCacheMaps.put(lifecycle, threadLocalCacheMap);
        }
        if ((threadLocalCache = threadLocalCacheMap.get(name)) == null) {
            threadLocalCache = new ThreadLocalCache(name, lifecycle);
            threadLocalCacheMap.put(name, threadLocalCache);
        }
        return threadLocalCache;
    }

    private static class EmptyThreadLocalCahce<T>
    extends ThreadLocalCache<T> {
        public EmptyThreadLocalCahce() {
            super(null, null);
        }

        @Override
        public T get(String key) {
            return null;
        }

        @Override
        public void put(String key, T obj) {
        }

        @Override
        public void remove(String key) {
        }

        @Override
        public void removeAll() {
        }

        @Override
        public String toString() {
            return EmptyThreadLocalCahce.class.getName();
        }
    }
}

