/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBProcess;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.NamingException;

public abstract class BaseDBProcess
implements DBProcess {
    protected Connection connection;
    private static final Log _log = LogFactoryUtil.getLog(BaseDBProcess.class);

    @Override
    public void runSQL(Connection connection, String template) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        db.runSQL(connection, template);
    }

    @Override
    public void runSQL(String template) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(template);
        } else {
            db.runSQL(this.connection, template);
        }
    }

    @Override
    public void runSQL(String[] templates) throws IOException, SQLException {
        DB db = DBManagerUtil.getDB();
        if (this.connection == null) {
            db.runSQL(templates);
        } else {
            db.runSQL(this.connection, templates);
        }
    }

    @Override
    public void runSQLTemplate(String path) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer(path);){
            DB db = DBManagerUtil.getDB();
            db.runSQLTemplate(path);
        }
    }

    @Override
    public void runSQLTemplate(String path, boolean failOnError) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer(path);){
            DB db = DBManagerUtil.getDB();
            db.runSQLTemplate(path, failOnError);
        }
    }

    @Override
    public void runSQLTemplateString(String template, boolean evaluate, boolean failOnError) throws IOException, NamingException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DB db = DBManagerUtil.getDB();
            if (this.connection == null) {
                db.runSQLTemplateString(template, evaluate, failOnError);
            } else {
                db.runSQLTemplateString(this.connection, template, evaluate, failOnError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doHasTable(String tableName) throws Exception {
        ResultSet rs;
        Statement ps;
        block2: {
            boolean bl;
            ps = null;
            rs = null;
            try {
                DatabaseMetaData metadata = this.connection.getMetaData();
                rs = metadata.getTables(null, null, tableName, null);
                if (!rs.next()) break block2;
                bl = true;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp(ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp(ps, rs);
            return bl;
        }
        DataAccess.cleanUp(ps, rs);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasColumn(String tableName, String columnName) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select * from " + tableName);
             ResultSet rs = ps.executeQuery();){
            ResultSetMetaData rsmd = rs.getMetaData();
            int i = 0;
            while (i < rsmd.getColumnCount()) {
                String curColumnName = rsmd.getColumnName(i + 1);
                if (StringUtil.equalsIgnoreCase(curColumnName, columnName)) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
            return false;
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasRows(String tableName) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select count(*) from " + tableName);
             ResultSet rs = ps.executeQuery();){
            int count;
            do {
                if (!rs.next()) return false;
            } while ((count = rs.getInt(1)) <= 0);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return false;
    }

    protected boolean hasTable(String tableName) throws Exception {
        return this.doHasTable(StringUtil.toLowerCase(tableName)) || this.doHasTable(StringUtil.toUpperCase(tableName)) || this.doHasTable(tableName);
    }
}

