/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging;

import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.Collections;
import java.util.Set;

public class HotDeployMessageListener
extends BaseMessageListener {
    private final Set<String> _servletContextNames;

    public HotDeployMessageListener() {
        this(null);
    }

    public HotDeployMessageListener(String ... servletContextNames) {
        this._servletContextNames = servletContextNames == null ? Collections.emptySet() : SetUtil.fromArray(servletContextNames);
    }

    @Override
    protected void doReceive(Message message) throws Exception {
        String servletContextName = GetterUtil.getString(message.getString("servletContextName"));
        if (!this._servletContextNames.isEmpty() && !this._servletContextNames.contains(servletContextName)) {
            return;
        }
        String command = GetterUtil.getString(message.getString("command"));
        if (command.equals("deploy")) {
            this.onDeploy(message);
        } else if (command.equals("undeploy")) {
            this.onUndeploy(message);
        }
    }

    protected void onDeploy(Message message) throws Exception {
    }

    protected void onUndeploy(Message message) throws Exception {
    }
}

