/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.messaging.proxy;

import com.liferay.portal.kernel.annotation.AnnotationLocator;
import com.liferay.portal.kernel.messaging.proxy.MessagingProxy;
import com.liferay.portal.kernel.messaging.proxy.ProxyMode;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyRequest
implements Externalizable {
    private static final Map<Method, boolean[]> _localAndSynchronousMap = new ConcurrentHashMap<Method, boolean[]>();
    private Object[] _arguments;
    private boolean _hasReturnValue;
    private final boolean _local;
    private Method _method;
    private boolean _synchronous;

    public ProxyRequest() {
        this._local = false;
    }

    public ProxyRequest(Method method, Object[] arguments) throws Exception {
        boolean[] localAndSynchronous;
        this._method = method;
        this._arguments = arguments;
        if (method.getReturnType() != Void.TYPE) {
            this._hasReturnValue = true;
        }
        if ((localAndSynchronous = _localAndSynchronousMap.get(method)) == null) {
            localAndSynchronous = new boolean[2];
            MessagingProxy messagingProxy = AnnotationLocator.locate(method, method.getDeclaringClass(), MessagingProxy.class);
            if (messagingProxy != null) {
                ProxyMode proxyMode;
                if (messagingProxy.local()) {
                    localAndSynchronous[0] = true;
                }
                if ((proxyMode = messagingProxy.mode()).equals((Object)ProxyMode.SYNC)) {
                    localAndSynchronous[1] = true;
                }
            }
            _localAndSynchronousMap.put(method, localAndSynchronous);
        }
        this._local = localAndSynchronous[0];
        this._synchronous = localAndSynchronous[1];
    }

    public Object execute(Object object) throws Exception {
        try {
            return this._method.invoke(object, this._arguments);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }

    public Object[] getArguments() {
        return this._arguments;
    }

    public boolean hasReturnValue() {
        return this._hasReturnValue;
    }

    public boolean isLocal() {
        return this._local;
    }

    public boolean isSynchronous() {
        return this._synchronous;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._arguments = (Object[])objectInput.readObject();
        this._hasReturnValue = objectInput.readBoolean();
        MethodKey methodKey = (MethodKey)objectInput.readObject();
        try {
            this._method = methodKey.getMethod();
        }
        catch (NoSuchMethodException nsme) {
            throw new IOException(nsme);
        }
        this._synchronous = objectInput.readBoolean();
    }

    public String toString() {
        StringBundler sb = new StringBundler(9);
        sb.append("{arguments=");
        sb.append(Arrays.toString(this._arguments));
        sb.append(", hasReturnValue=");
        sb.append(this._hasReturnValue);
        sb.append(", method=");
        sb.append(this._method);
        sb.append(", synchronous");
        sb.append(this._synchronous);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this._arguments);
        objectOutput.writeBoolean(this._hasReturnValue);
        objectOutput.writeObject(new MethodKey(this._method));
        objectOutput.writeBoolean(this._synchronous);
    }
}

