/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LiferayPortlet
extends GenericPortlet {
    protected boolean addProcessActionSuccessMessage;
    protected boolean alwaysSendRedirect;
    private static final String[] _IGNORED_SESSION_MESSAGE_SUFFIXES = new String[]{".deleteSuccessData", ".forceSendRedirect", ".hideDefaultErrorMessage", ".hideDefaultSuccessMessage", ".refreshPortlet"};
    private static final boolean _PROCESS_PORTLET_REQUEST = true;
    private static final Log _log = LogFactoryUtil.getLog(LiferayPortlet.class);
    private final Map<String, Method> _actionMethods = new ConcurrentHashMap<String, Method>();
    private final Map<String, Method> _resourceMethods = new ConcurrentHashMap<String, Method>();

    public void init() throws PortletException {
        super.init();
        this.addProcessActionSuccessMessage = GetterUtil.getBoolean(this.getInitParameter("add-process-action-success-action"), true);
        this.alwaysSendRedirect = GetterUtil.getBoolean(this.getInitParameter("always-send-redirect"));
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        try {
            if (!this.isProcessActionRequest(actionRequest)) {
                return;
            }
            if (!this.callActionMethod(actionRequest, actionResponse)) {
                return;
            }
            if (!SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                return;
            }
            boolean emptySessionMessages = this.isEmptySessionMessages(actionRequest);
            if (emptySessionMessages) {
                this.addSuccessMessage(actionRequest, actionResponse);
            }
            if (!SessionMessages.contains((PortletRequest)actionRequest, PortalUtil.getPortletId((PortletRequest)actionRequest) + ".forceSendRedirect") && (emptySessionMessages || this.isAlwaysSendRedirect())) {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (PortletException pe) {
            Throwable cause = pe.getCause();
            if (this.isSessionErrorException(cause)) {
                SessionErrors.add((PortletRequest)actionRequest, cause.getClass(), (Object)cause);
            }
            throw pe;
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (!this.isProcessResourceRequest(resourceRequest)) {
            return;
        }
        if (!this.callResourceMethod(resourceRequest, resourceResponse)) {
            return;
        }
        if (!SessionErrors.isEmpty((PortletRequest)resourceRequest)) {
            return;
        }
        if (!SessionMessages.isEmpty((PortletRequest)resourceRequest)) {
            return;
        }
        super.serveResource(resourceRequest, resourceResponse);
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        if (!this.addProcessActionSuccessMessage) {
            return;
        }
        String successMessage = ParamUtil.getString((PortletRequest)actionRequest, "successMessage");
        SessionMessages.add((PortletRequest)actionRequest, "requestProcessed", (Object)successMessage);
    }

    protected boolean callActionMethod(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, "javax.portlet.action");
        if (Validator.isNull(actionName) || actionName.equals("callActionMethod") || actionName.equals("processAction")) {
            return false;
        }
        try {
            Method method = this.getActionMethod(actionName);
            method.invoke((Object)this, actionRequest, actionResponse);
            return true;
        }
        catch (NoSuchMethodException nsme) {
            try {
                super.processAction(actionRequest, actionResponse);
                return true;
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause != null) {
                throw new PortletException(cause);
            }
            throw new PortletException((Throwable)ite);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected boolean callResourceMethod(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        String actionName = ParamUtil.getString((PortletRequest)resourceRequest, "javax.portlet.action");
        if (Validator.isNull(actionName) || actionName.equals("callResourceMethod") || actionName.equals("serveResource")) {
            return false;
        }
        try {
            Method method = this.getResourceMethod(actionName);
            method.invoke((Object)this, resourceRequest, resourceResponse);
            return true;
        }
        catch (NoSuchMethodException nsme) {
            try {
                super.serveResource(resourceRequest, resourceResponse);
                return true;
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause != null) {
                throw new PortletException(cause);
            }
            throw new PortletException((Throwable)ite);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void doAbout(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doAbout method not implemented");
    }

    protected void doConfig(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doConfig method not implemented");
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (!this.isProcessRenderRequest(renderRequest)) {
            renderRequest.setAttribute("PORTLET_DECORATE", (Object)Boolean.FALSE);
            return;
        }
        WindowState windowState = renderRequest.getWindowState();
        if (windowState.equals((Object)WindowState.MINIMIZED)) {
            return;
        }
        PortletMode portletMode = renderRequest.getPortletMode();
        if (portletMode.equals((Object)PortletMode.VIEW)) {
            this.doView(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.ABOUT)) {
            this.doAbout(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.CONFIG)) {
            this.doConfig(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)PortletMode.EDIT)) {
            this.doEdit(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_DEFAULTS)) {
            this.doEditDefaults(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_GUEST)) {
            this.doEditGuest(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)PortletMode.HELP)) {
            this.doHelp(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.PREVIEW)) {
            this.doPreview(renderRequest, renderResponse);
        } else if (portletMode.equals((Object)LiferayPortletMode.PRINT)) {
            this.doPrint(renderRequest, renderResponse);
        } else {
            throw new PortletException(portletMode.toString());
        }
    }

    protected void doEditDefaults(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doEditDefaults method not implemented");
    }

    protected void doEditGuest(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doEditGuest method not implemented");
    }

    protected void doPreview(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doPreview method not implemented");
    }

    protected void doPrint(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        throw new PortletException("doPrint method not implemented");
    }

    protected Method getActionMethod(String actionName) throws NoSuchMethodException {
        Method method = this._actionMethods.get(actionName);
        if (method != null) {
            return method;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        method = clazz.getMethod(actionName, ActionRequest.class, ActionResponse.class);
        this._actionMethods.put(actionName, method);
        return method;
    }

    protected String getJSONContentType(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest(portletRequest);
        if (BrowserSnifferUtil.isIe(request)) {
            return "text/html";
        }
        return "application/json";
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse) {
        String redirect = (String)actionRequest.getAttribute("REDIRECT");
        if (Validator.isNull(redirect)) {
            redirect = ParamUtil.getString((PortletRequest)actionRequest, "redirect");
        }
        return redirect;
    }

    protected Method getResourceMethod(String actionName) throws NoSuchMethodException {
        Method method = this._resourceMethods.get(actionName);
        if (method != null) {
            return method;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        method = clazz.getMethod(actionName, ResourceRequest.class, ResourceResponse.class);
        this._resourceMethods.put(actionName, method);
        return method;
    }

    protected ServletContext getServletContext() {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)this.getPortletConfig();
        Portlet portlet = liferayPortletConfig.getPortlet();
        PortletApp portletApp = portlet.getPortletApp();
        return portletApp.getServletContext();
    }

    protected String getTitle(RenderRequest renderRequest) {
        try {
            return PortalUtil.getPortletTitle((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            return super.getTitle(renderRequest);
        }
    }

    protected boolean isAlwaysSendRedirect() {
        return this.alwaysSendRedirect;
    }

    protected boolean isEmptySessionMessages(ActionRequest actionRequest) {
        if (SessionMessages.isEmpty((PortletRequest)actionRequest)) {
            return true;
        }
        int sessionMessagesSize = SessionMessages.size((PortletRequest)actionRequest);
        String portletId = PortalUtil.getPortletId((PortletRequest)actionRequest);
        for (String suffix : _IGNORED_SESSION_MESSAGE_SUFFIXES) {
            if (!SessionMessages.contains((PortletRequest)actionRequest, portletId + suffix)) continue;
            --sessionMessagesSize;
        }
        return sessionMessagesSize == 0;
    }

    protected boolean isProcessActionRequest(ActionRequest actionRequest) {
        return this.isProcessPortletRequest((PortletRequest)actionRequest);
    }

    protected boolean isProcessPortletRequest(PortletRequest portletRequest) {
        return true;
    }

    protected boolean isProcessRenderRequest(RenderRequest renderRequest) {
        return this.isProcessPortletRequest((PortletRequest)renderRequest);
    }

    protected boolean isProcessResourceRequest(ResourceRequest resourceRequest) {
        return this.isProcessPortletRequest((PortletRequest)resourceRequest);
    }

    protected boolean isSessionErrorException(Throwable cause) {
        if (_log.isDebugEnabled()) {
            _log.debug(cause, cause);
        }
        return cause instanceof PortalException;
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        String redirect = this.getRedirect(actionRequest, actionResponse);
        if (Validator.isNotNull(redirect)) {
            actionResponse.sendRedirect(redirect);
        }
    }

    protected String translate(PortletRequest portletRequest, String key) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ResourceBundle resourceBundle = this.getResourceBundle(themeDisplay.getLocale());
        return LanguageUtil.get(resourceBundle, key);
    }

    protected String translate(PortletRequest portletRequest, String key, Object ... arguments) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ResourceBundle resourceBundle = this.getResourceBundle(themeDisplay.getLocale());
        return LanguageUtil.format(resourceBundle, key, arguments);
    }

    protected void writeJSON(PortletRequest portletRequest, ActionResponse actionResponse, Object json) throws IOException {
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        response.setContentType(this.getJSONContentType(portletRequest));
        ServletResponseUtil.write(response, json.toString());
        response.flushBuffer();
    }

    protected void writeJSON(PortletRequest portletRequest, MimeResponse mimeResponse, Object json) throws IOException {
        mimeResponse.setContentType(this.getJSONContentType(portletRequest));
        PortletResponseUtil.write(mimeResponse, json.toString());
        mimeResponse.flushBuffer();
    }
}

