/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet.bridges.mvc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCCommand;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.util.StringPlus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MVCCommandCache {
    private static final Log _log = LogFactoryUtil.getLog(MVCCommandCache.class);
    private final MVCCommand _emptyMVCCommand;
    private final String _mvcComandPostFix;
    private final Map<String, MVCCommand> _mvcCommandCache = new ConcurrentHashMap<String, MVCCommand>();
    private final Map<String, List<String>> _mvcCommandKeys = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<MVCCommand>> _mvcCommands = new ConcurrentHashMap<String, List<MVCCommand>>();
    private final String _packagePrefix;
    private final ServiceTracker<MVCCommand, MVCCommand> _serviceTracker;

    public MVCCommandCache(MVCCommand emptyMVCCommand, String packagePrefix, String portletName, String mvcCommandClassName, String mvcCommandPostFix) {
        this._emptyMVCCommand = emptyMVCCommand;
        this._mvcComandPostFix = mvcCommandPostFix;
        if (Validator.isNotNull(packagePrefix) && !packagePrefix.endsWith(".")) {
            packagePrefix = packagePrefix + ".";
        }
        this._packagePrefix = packagePrefix;
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(javax.portlet.name=" + portletName + ")(mvc.command.name=*)" + "(objectClass=" + mvcCommandClassName + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new MVCCommandServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void close() {
        this._serviceTracker.close();
    }

    public MVCCommand getMVCCommand(String mvcCommandName) {
        String className = null;
        try {
            MVCCommand mvcCommand = this._mvcCommandCache.get(mvcCommandName);
            if (mvcCommand != null) {
                return mvcCommand;
            }
            if (Validator.isNull(this._packagePrefix)) {
                return this._emptyMVCCommand;
            }
            StringBundler sb = new StringBundler(4);
            sb.append(this._packagePrefix);
            sb.append(Character.toUpperCase(mvcCommandName.charAt(0)));
            sb.append(mvcCommandName.substring(1));
            sb.append(this._mvcComandPostFix);
            className = sb.toString();
            mvcCommand = (MVCCommand)InstanceFactory.newInstance(className);
            this._mvcCommandCache.put(mvcCommandName, mvcCommand);
            return mvcCommand;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to instantiate MVCCommand " + className);
            }
            this._mvcCommandCache.put(mvcCommandName, this._emptyMVCCommand);
            return this._emptyMVCCommand;
        }
    }

    public List<? extends MVCCommand> getMVCCommands(String key) {
        List<MVCCommand> mvcCommands = this._mvcCommands.get(key);
        String[] mvcCommandNames = StringUtil.split(key);
        if (mvcCommands != null && mvcCommands.size() == mvcCommandNames.length) {
            return mvcCommands;
        }
        mvcCommands = new ArrayList<MVCCommand>();
        for (String mvcCommandName : mvcCommandNames) {
            MVCCommand mvcCommand = this.getMVCCommand(mvcCommandName);
            if (mvcCommand != this._emptyMVCCommand) {
                mvcCommands.add(mvcCommand);
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn("Unable to find MVCCommand " + key);
        }
        this._mvcCommands.put(key, mvcCommands);
        for (MVCCommand mvcCommand : mvcCommands) {
            String mvcCommandClassName = ClassUtil.getClassName(mvcCommand);
            List<String> keys = this._mvcCommandKeys.get(mvcCommandClassName);
            if (keys == null) {
                keys = new ArrayList<String>();
                this._mvcCommandKeys.put(mvcCommandClassName, keys);
            }
            keys.add(key);
        }
        return mvcCommands;
    }

    public boolean isEmpty() {
        return this._mvcCommandCache.isEmpty();
    }

    private class MVCCommandServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<MVCCommand, MVCCommand> {
        private MVCCommandServiceTrackerCustomizer() {
        }

        public MVCCommand addingService(ServiceReference<MVCCommand> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            MVCCommand mvcCommand = (MVCCommand)registry.getService(serviceReference);
            List mvcCommandNames = StringPlus.asList((Object)serviceReference.getProperty("mvc.command.name"));
            for (String mvcCommandName : mvcCommandNames) {
                MVCCommandCache.this._mvcCommandCache.put(mvcCommandName, mvcCommand);
            }
            return mvcCommand;
        }

        public void modifiedService(ServiceReference<MVCCommand> serviceReference, MVCCommand mvcCommand) {
        }

        public void removedService(ServiceReference<MVCCommand> serviceReference, MVCCommand mvcCommand) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            List mvcCommandNames = StringPlus.asList((Object)serviceReference.getProperty("mvc.command.name"));
            for (String mvcCommandName : mvcCommandNames) {
                MVCCommandCache.this._mvcCommandCache.remove(mvcCommandName);
                for (List mvcCommands : MVCCommandCache.this._mvcCommands.values()) {
                    mvcCommands.remove(mvcCommand);
                }
                String mvcCommandClassName = ClassUtil.getClassName(mvcCommand);
                List mvcCommandKeys = (List)MVCCommandCache.this._mvcCommandKeys.remove(mvcCommandClassName);
                if (!ListUtil.isNotEmpty(mvcCommandKeys)) continue;
                for (String mvcCommandKey : mvcCommandKeys) {
                    MVCCommandCache.this._mvcCommandCache.remove(mvcCommandKey);
                }
            }
        }
    }
}

