/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcherHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FacetedSearcher
extends BaseSearcher {
    public static Indexer<?> getInstance() {
        return new FacetedSearcher();
    }

    protected void addSearchExpandoKeywords(BooleanQuery searchQuery, SearchContext searchContext, String keywords, String className) throws Exception {
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge(searchContext.getCompanyId(), className);
        Set<String> attributeNames = SetUtil.fromEnumeration(expandoBridge.getAttributeNames());
        for (String attributeName : attributeNames) {
            UnicodeProperties properties = expandoBridge.getAttributeProperties(attributeName);
            int indexType = GetterUtil.getInteger(properties.getProperty("index-type"));
            if (indexType == 0) continue;
            String fieldName = this.getExpandoFieldName(searchContext, expandoBridge, attributeName);
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm(fieldName, keywords);
                continue;
            }
            searchQuery.addTerm(fieldName, keywords);
        }
    }

    @Override
    protected BooleanQuery createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        BooleanClause<Query>[] booleanClauses;
        List<Group> inactiveGroups;
        BooleanQueryImpl searchQuery = new BooleanQueryImpl();
        String keywords = searchContext.getKeywords();
        if (Validator.isNotNull(keywords)) {
            this.addSearchLocalizedTerm(searchQuery, searchContext, "assetCategoryTitles", false);
            searchQuery.addExactTerm("assetTagNames", keywords);
            int groupId = GetterUtil.getInteger(searchContext.getAttribute("groupId"));
            if (groupId == 0) {
                fullQueryBooleanFilter.addTerm("stagingGroup", "true", BooleanClauseOccur.MUST_NOT);
            }
            searchQuery.addTerms(Field.KEYWORDS, keywords);
        }
        if (ListUtil.isNotEmpty(inactiveGroups = GroupLocalServiceUtil.getActiveGroups(searchContext.getCompanyId(), false))) {
            TermsFilter groupIdTermsFilter = new TermsFilter("groupId");
            groupIdTermsFilter.addValues(ArrayUtil.toStringArray((Object[])ListUtil.toArray(inactiveGroups, Group.GROUP_ID_ACCESSOR)));
            fullQueryBooleanFilter.add(groupIdTermsFilter, BooleanClauseOccur.MUST_NOT);
        }
        for (String entryClassName : searchContext.getEntryClassNames()) {
            String searchEngineId;
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer == null || !(searchEngineId = searchContext.getSearchEngineId()).equals(indexer.getSearchEngineId())) continue;
            if (Validator.isNotNull(keywords)) {
                this.addSearchExpandoKeywords(searchQuery, searchContext, keywords, entryClassName);
            }
            indexer.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
            for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
                indexerPostProcessor.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
            }
            this.doPostProcessSearchQuery(indexer, searchQuery, searchContext);
        }
        Map<String, Facet> facets = searchContext.getFacets();
        BooleanFilter facetBooleanFilter = new BooleanFilter();
        for (Facet facet : facets.values()) {
            BooleanClause<Filter> facetClause = facet.getFacetFilterBooleanClause();
            if (facetClause == null) continue;
            facetBooleanFilter.add(facetClause.getClause(), facetClause.getBooleanClauseOccur());
        }
        this.addFacetClause(searchContext, facetBooleanFilter, facets.values());
        if (facetBooleanFilter.hasClauses()) {
            fullQueryBooleanFilter.add(facetBooleanFilter, BooleanClauseOccur.MUST);
        }
        BooleanQueryImpl fullQuery = new BooleanQueryImpl();
        if (fullQueryBooleanFilter.hasClauses()) {
            fullQuery.setPreBooleanFilter(fullQueryBooleanFilter);
        }
        if (searchQuery.hasClauses()) {
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            for (BooleanClause<Query> booleanClause : booleanClauses) {
                fullQuery.add((Query)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
            }
        }
        for (String entryClassName : searchContext.getEntryClassNames()) {
            String searchEngineId;
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer == null || !(searchEngineId = searchContext.getSearchEngineId()).equals(indexer.getSearchEngineId())) continue;
            for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
                indexerPostProcessor.postProcessFullQuery(fullQuery, searchContext);
            }
        }
        return fullQuery;
    }

    @Override
    protected Hits doSearch(SearchContext searchContext) throws SearchException {
        try {
            searchContext.setSearchEngineId(this.getSearchEngineId());
            BooleanFilter queryBooleanFilter = new BooleanFilter();
            queryBooleanFilter.addRequiredTerm("companyId", searchContext.getCompanyId());
            Query fullQuery = this.createFullQuery(queryBooleanFilter, searchContext);
            if (!fullQuery.hasChildren()) {
                BooleanFilter preBooleanFilter = fullQuery.getPreBooleanFilter();
                fullQuery = new MatchAllQuery();
                fullQuery.setPreBooleanFilter(preBooleanFilter);
            }
            QueryConfig queryConfig = searchContext.getQueryConfig();
            fullQuery.setQueryConfig(queryConfig);
            return IndexSearcherHelperUtil.search(searchContext, fullQuery);
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        if (searchContext.getEntryClassNames() == null) {
            return super.isFilterSearch();
        }
        for (String entryClassName : searchContext.getEntryClassNames()) {
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer == null || !indexer.isFilterSearch()) continue;
            return true;
        }
        return super.isFilterSearch();
    }
}

