/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.RelatedSearchResult;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class SearchResult {
    private String _className;
    private long _classPK;
    private final List<RelatedSearchResult<Comment>> _commentRelatedSearchResults = new ArrayList<RelatedSearchResult<Comment>>();
    private final List<RelatedSearchResult<FileEntry>> _fileEntryRelatedSearchResults = new ArrayList<RelatedSearchResult<FileEntry>>();
    private Summary _summary;
    private final List<String> _versions = new ArrayList<String>();

    public SearchResult(String className, long classPK) {
        this._className = className;
        this._classPK = classPK;
    }

    public void addComment(Comment comment, Summary summary) {
        this._commentRelatedSearchResults.add(new RelatedSearchResult<Comment>(comment, summary));
    }

    public void addFileEntry(FileEntry fileEntry, Summary summary) {
        this._fileEntryRelatedSearchResults.add(new RelatedSearchResult<FileEntry>(fileEntry, summary));
    }

    public void addVersion(String version) {
        this._versions.add(version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SearchResult)) {
            return false;
        }
        SearchResult searchResult = (SearchResult)obj;
        return Validator.equals(this._classPK, searchResult._classPK) && Validator.equals(this._className, searchResult._className);
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public List<RelatedSearchResult<Comment>> getCommentRelatedSearchResults() {
        return this._commentRelatedSearchResults;
    }

    public List<RelatedSearchResult<FileEntry>> getFileEntryRelatedSearchResults() {
        return this._fileEntryRelatedSearchResults;
    }

    public Summary getSummary() {
        return this._summary;
    }

    public List<String> getVersions() {
        return this._versions;
    }

    public int hashCode() {
        int hash = HashUtil.hash(0, this._classPK);
        return HashUtil.hash(hash, this._className);
    }

    @Deprecated
    public void setClassName(String className) {
        this._className = className;
    }

    @Deprecated
    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setSummary(Summary summary) {
        this._summary = summary;
    }
}

