/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;

public class PortletSessionTracker {
    private static final ConcurrentMap<String, Map<String, HttpSession>> _sessions = new ConcurrentHashMap<String, Map<String, HttpSession>>();

    public static void add(HttpSession session) {
        ServletContext servletContext;
        String contextPath;
        Map previousSessions;
        Map<String, Object> sessions;
        String sessionId = session.getId();
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            sessionId = CompoundSessionIdSplitterUtil.parseSessionId(sessionId);
        }
        if ((sessions = (ConcurrentHashMap<String, HttpSession>)_sessions.get(sessionId)) == null && (previousSessions = (Map)_sessions.putIfAbsent(sessionId, sessions = new ConcurrentHashMap<String, HttpSession>())) != null) {
            sessions = previousSessions;
        }
        if (!sessions.containsKey(contextPath = (servletContext = session.getServletContext()).getContextPath())) {
            sessions.put(contextPath, session);
        }
    }

    public static void invalidate(String sessionId) {
        Map sessions;
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter()) {
            sessionId = CompoundSessionIdSplitterUtil.parseSessionId(sessionId);
        }
        if ((sessions = (Map)_sessions.remove(sessionId)) == null) {
            return;
        }
        for (HttpSession session : sessions.values()) {
            try {
                session.invalidate();
            }
            catch (Exception e) {}
        }
    }
}

