/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.templateparser;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TemplateNode
extends LinkedHashMap<String, Object> {
    private static final String _LAYOUT_TYPE_PRIVATE_GROUP = "private-group";
    private static final String _LAYOUT_TYPE_PRIVATE_USER = "private-user";
    private static final String _LAYOUT_TYPE_PUBLIC = "public";
    private static final Log _log = LogFactoryUtil.getLog(TemplateNode.class);
    private final Map<String, TemplateNode> _childTemplateNodes = new LinkedHashMap<String, TemplateNode>();
    private final List<TemplateNode> _siblingTemplateNodes = new ArrayList<TemplateNode>();
    private ThemeDisplay _themeDisplay;

    public TemplateNode(ThemeDisplay themeDisplay, String name, String data, String type, Map<String, String> attributes) {
        this._themeDisplay = themeDisplay;
        this.put("attributes", attributes);
        this.put("name", name);
        this.put("data", data);
        this.put("type", type);
        this.put("options", new ArrayList());
        this.put("optionsMap", new HashMap());
    }

    public void appendChild(TemplateNode templateNode) {
        this._childTemplateNodes.put(templateNode.getName(), templateNode);
        this.put(templateNode.getName(), templateNode);
    }

    public void appendChildren(List<TemplateNode> templateNodes) {
        for (TemplateNode templateNode : templateNodes) {
            this.appendChild(templateNode);
        }
    }

    public void appendOption(String option) {
        List<String> options = this.getOptions();
        options.add(option);
    }

    public void appendOptionMap(String value, String label) {
        Map<String, String> optionsMap = this.getOptionsMap();
        optionsMap.put(value, label);
    }

    public void appendOptions(List<String> options) {
        List<String> curOptions = this.getOptions();
        curOptions.addAll(options);
    }

    public void appendOptionsMap(Map<String, String> optionMap) {
        Map<String, String> optionsMap = this.getOptionsMap();
        optionsMap.putAll(optionMap);
    }

    public void appendSibling(TemplateNode templateNode) {
        this._siblingTemplateNodes.add(templateNode);
    }

    public String getAttribute(String name) {
        Map<String, String> attributes = this.getAttributes();
        if (attributes == null) {
            return "";
        }
        return attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return (Map)this.get("attributes");
    }

    public TemplateNode getChild(String name) {
        return this._childTemplateNodes.get(name);
    }

    public List<TemplateNode> getChildren() {
        return new ArrayList<TemplateNode>(this._childTemplateNodes.values());
    }

    public String getData() {
        String type = this.getType();
        if (type.equals("link_to_layout")) {
            String data = (String)this.get("data");
            int pos = data.indexOf(64);
            if (pos != -1) {
                data = data.substring(0, pos);
            }
            return data;
        }
        return (String)this.get("data");
    }

    public String getFriendlyUrl() {
        if (this._themeDisplay == null) {
            return this.getUrl();
        }
        String type = this.getType();
        if (!type.equals("link_to_layout")) {
            return "";
        }
        String layoutType = this.getLayoutType();
        if (Validator.isNull(layoutType)) {
            return "";
        }
        long groupId = this.getLayoutGroupId();
        if (groupId == 0L) {
            groupId = this._themeDisplay.getScopeGroupId();
        }
        boolean privateLayout = layoutType.startsWith("private");
        try {
            Layout layout = LayoutLocalServiceUtil.getLayout(groupId, privateLayout, this.getLayoutId());
            return PortalUtil.getLayoutFriendlyURL(layout, this._themeDisplay);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug("Error finding friendly URL on page " + this._themeDisplay.getURLCurrent(), e);
            }
            return this.getUrl();
        }
    }

    public String getName() {
        return (String)this.get("name");
    }

    public List<String> getOptions() {
        return (List)this.get("options");
    }

    public Map<String, String> getOptionsMap() {
        return (Map)this.get("optionsMap");
    }

    public List<TemplateNode> getSiblings() {
        return this._siblingTemplateNodes;
    }

    public String getType() {
        return (String)this.get("type");
    }

    public String getUrl() {
        String type = this.getType();
        if (!type.equals("link_to_layout")) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        String layoutType = this.getLayoutType();
        if (Validator.isNull(layoutType)) {
            return "";
        }
        if (layoutType.equals(_LAYOUT_TYPE_PRIVATE_GROUP)) {
            sb.append(PortalUtil.getPathFriendlyURLPrivateGroup());
        } else if (layoutType.equals(_LAYOUT_TYPE_PRIVATE_USER)) {
            sb.append(PortalUtil.getPathFriendlyURLPrivateUser());
        } else if (layoutType.equals(_LAYOUT_TYPE_PUBLIC)) {
            sb.append(PortalUtil.getPathFriendlyURLPublic());
        } else {
            sb.append("@friendly_url_current@");
        }
        sb.append("/");
        try {
            Group group = GroupLocalServiceUtil.getGroup(this.getLayoutGroupId());
            String name = group.getFriendlyURL();
            name = name.substring(1);
            sb.append(name);
        }
        catch (Exception e) {
            sb.append("@group_id@");
        }
        sb.append("/");
        sb.append(this.getLayoutId());
        return sb.toString();
    }

    protected long getLayoutGroupId() {
        String data = (String)this.get("data");
        int pos = data.lastIndexOf(64);
        if (pos != -1) {
            data = data.substring(pos + 1);
        }
        return GetterUtil.getLong(data);
    }

    protected long getLayoutId() {
        String data = (String)this.get("data");
        int pos = data.indexOf(64);
        if (pos != -1) {
            data = data.substring(0, pos);
        }
        return GetterUtil.getLong(data);
    }

    protected String getLayoutType() {
        String data = (String)this.get("data");
        int x = data.indexOf(64);
        int y = data.lastIndexOf(64);
        if (x != -1 && y != -1) {
            data = x == y ? data.substring(x + 1) : data.substring(x + 1, y);
        }
        return data;
    }
}

