/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;

public abstract class BaseUpgradePortletPreferences
extends UpgradeProcess {
    protected void deletePortletPreferences(long portletPreferencesId) throws Exception {
        this.runSQL("delete from PortletPreferences where portletPreferencesId = " + portletPreferencesId);
    }

    @Override
    protected void doUpgrade() throws Exception {
        this.updatePortletPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getCompanyId(String sql, long primaryKey) throws Exception {
        long companyId = 0L;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement(sql);
            ps.setLong(1, primaryKey);
            rs = ps.executeQuery();
            while (rs.next()) {
                companyId = rs.getLong("companyId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(ps, rs);
        return companyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getGroup(long groupId) throws Exception {
        Object[] group = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement("select companyId from Group_ where groupId = ?");
            ps.setLong(1, groupId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                group = new Object[]{groupId, companyId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(ps, rs);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getLayout(long plid) throws Exception {
        Object[] layout = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement("select groupId, companyId, privateLayout, layoutId from Layout where plid = ?");
            ps.setLong(1, plid);
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                boolean privateLayout = rs.getBoolean("privateLayout");
                long layoutId = rs.getLong("layoutId");
                layout = new Object[]{groupId, companyId, privateLayout, layoutId};
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(ps, rs);
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLayoutUuid(long plid, long layoutId) throws Exception {
        Object[] layout = this.getLayout(plid);
        if (layout == null) {
            return null;
        }
        String uuid = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement("select uuid_ from Layout where groupId = ? and privateLayout = ? and layoutId = ?");
            long groupId = (Long)layout[0];
            boolean privateLayout = (Boolean)layout[2];
            ps.setLong(1, groupId);
            ps.setBoolean(2, privateLayout);
            ps.setLong(3, layoutId);
            rs = ps.executeQuery();
            if (rs.next()) {
                uuid = rs.getString("uuid_");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(ps, rs);
        return uuid;
    }

    protected String[] getPortletIds() {
        return new String[0];
    }

    protected String getUpdatePortletPreferencesWhereClause() {
        String[] portletIds = this.getPortletIds();
        if (portletIds.length == 0) {
            throw new IllegalArgumentException("Subclasses must override getPortletIds or getUpdatePortletPreferencesWhereClause");
        }
        StringBundler sb = new StringBundler(portletIds.length * 5 - 1);
        for (int i = 0; i < portletIds.length; ++i) {
            String portletId = portletIds[i];
            sb.append("portletId ");
            if (portletId.contains("%")) {
                sb.append(" like '");
                sb.append(portletId);
                sb.append("'");
            } else {
                sb.append(" = '");
                sb.append(portletId);
                sb.append("'");
            }
            if (i + 1 >= portletIds.length) continue;
            sb.append(" or ");
        }
        return sb.toString();
    }

    protected void updatePortletPreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(4);
            sb.append("select portletPreferencesId, ownerId, ownerType, ");
            sb.append("plid, portletId, preferences from PortletPreferences");
            String whereClause = this.getUpdatePortletPreferencesWhereClause();
            if (Validator.isNotNull(whereClause)) {
                sb.append(" where ");
                sb.append(whereClause);
            }
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long portletPreferencesId = rs.getLong("portletPreferencesId");
                    long ownerId = rs.getLong("ownerId");
                    int ownerType = rs.getInt("ownerType");
                    long plid = rs.getLong("plid");
                    String portletId = rs.getString("portletId");
                    String preferences = GetterUtil.getString(rs.getString("preferences"));
                    long companyId = 0L;
                    if (ownerType == 5) {
                        companyId = this.getCompanyId("select companyId from PortletItem where portletItemId = ?", ownerId);
                    } else if (ownerType == 1) {
                        companyId = ownerId;
                    } else if (ownerType == 2) {
                        Object[] group = this.getGroup(ownerId);
                        if (group != null) {
                            companyId = (Long)group[1];
                        }
                    } else if (ownerType == 3) {
                        Object[] layout = this.getLayout(plid);
                        if (layout != null) {
                            companyId = (Long)layout[1];
                        }
                    } else if (ownerType == 6) {
                        companyId = this.getCompanyId("select companyId from Organization_ where organizationId = ?", ownerId);
                    } else if (ownerType == 4) {
                        companyId = this.getCompanyId("select companyId from User_ where userId = ?", ownerId);
                    } else {
                        throw new UnsupportedOperationException("Unsupported owner type " + ownerType);
                    }
                    if (companyId > 0L) {
                        String newPreferences = this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, preferences);
                        if (preferences.equals(newPreferences)) continue;
                        this.updatePortletPreferences(portletPreferencesId, newPreferences);
                        continue;
                    }
                    this.deletePortletPreferences(portletPreferencesId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePortletPreferences(long portletPreferencesId, String preferences) throws Exception {
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement("update PortletPreferences set preferences = ? where portletPreferencesId = " + portletPreferencesId);
            ps.setString(1, preferences);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps);
            throw throwable;
        }
        DataAccess.cleanUp(ps);
    }

    protected void upgradeMultiValuePreference(PortletPreferences portletPreferences, String key) throws ReadOnlyException {
        String value = portletPreferences.getValue(key, "");
        if (Validator.isNotNull(value)) {
            portletPreferences.setValues(key, StringUtil.split(value));
        }
    }

    protected abstract String upgradePreferences(long var1, long var3, int var5, long var6, String var8, String var9) throws Exception;
}

